/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.atif.buildnotes.Buildnotes;
import net.atif.buildnotes.network.packet.c2s.RequestImageC2SPacket;
import net.atif.buildnotes.network.packet.c2s.UploadImageChunkC2SPacket;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_8710;

public class ClientImageTransferManager {
    private static final Map<FileKey, ImageAssembler> IN_PROGRESS_DOWNLOADS = Maps.newConcurrentMap();
    private static final Map<FileKey, Runnable> COMPLETION_CALLBACKS = Maps.newConcurrentMap();
    private static final Set<FileKey> FAILED_DOWNLOADS = Sets.newConcurrentHashSet();
    private static final Queue<FileKey> UPLOAD_QUEUE = new LinkedList<FileKey>();
    private static boolean isUploading = false;

    public static void clearFailedDownloads() {
        FAILED_DOWNLOADS.clear();
    }

    public static void requestImage(UUID buildId, String filename, Runnable onComplete) {
        try {
            if (buildId == null || filename == null) {
                return;
            }
            FileKey key = new FileKey(buildId, filename);
            if (FAILED_DOWNLOADS.contains(key)) {
                if (onComplete != null) {
                    onComplete.run();
                }
                return;
            }
            if (COMPLETION_CALLBACKS.putIfAbsent(key, onComplete) != null) {
                return;
            }
            Buildnotes.LOGGER.info("Requesting image '{}' for build {}", (Object)filename, (Object)key.buildId);
            ClientPlayNetworking.send((class_8710)new RequestImageC2SPacket(buildId, filename));
        }
        catch (Exception e) {
            Buildnotes.LOGGER.error("[CRITICAL] An unexpected exception occurred inside requestImage!", (Throwable)e);
        }
    }

    public static void handleChunk(UUID buildId, String filename, int totalChunks, int chunkIndex, byte[] data) {
        FileKey key = new FileKey(buildId, filename);
        if (totalChunks <= 0 || totalChunks > 10000) {
            Buildnotes.LOGGER.error("Invalid totalChunks: {}", (Object)totalChunks);
            return;
        }
        ImageAssembler assembler = IN_PROGRESS_DOWNLOADS.computeIfAbsent(key, k -> new ImageAssembler(totalChunks));
        if (assembler.addChunk(chunkIndex, data)) {
            Runnable callback;
            byte[] fullImageData = assembler.reassemble();
            if (fullImageData != null) {
                ClientImageTransferManager.saveImage(buildId, filename, fullImageData);
            }
            IN_PROGRESS_DOWNLOADS.remove(key);
            if (COMPLETION_CALLBACKS.containsKey(key) && (callback = COMPLETION_CALLBACKS.remove(key)) != null) {
                callback.run();
            }
        }
    }

    private static Path getLocalImagePath(UUID buildId, String filename) {
        return FabricLoader.getInstance().getConfigDir().resolve("buildnotes").resolve("images").resolve(buildId.toString()).resolve(filename);
    }

    private static void saveImage(UUID buildId, String filename, byte[] data) {
        try {
            Path imagePath = ClientImageTransferManager.getLocalImagePath(buildId, filename);
            Files.createDirectories(imagePath.getParent(), new FileAttribute[0]);
            Files.write(imagePath, data, new OpenOption[0]);
            Buildnotes.LOGGER.info("Successfully saved downloaded image '{}' for build {}", (Object)filename, (Object)buildId);
        }
        catch (IOException e) {
            Buildnotes.LOGGER.error("Failed to save client-side image {} for build {}", new Object[]{filename, buildId, e});
        }
    }

    public static void onDownloadFailed(UUID buildId, String filename) {
        Runnable callback;
        FileKey key = new FileKey(buildId, filename);
        Buildnotes.LOGGER.warn("Server reported image not found: '{}' for build {}", (Object)filename, (Object)buildId);
        FAILED_DOWNLOADS.add(key);
        IN_PROGRESS_DOWNLOADS.remove(key);
        if (COMPLETION_CALLBACKS.containsKey(key) && (callback = COMPLETION_CALLBACKS.remove(key)) != null) {
            callback.run();
        }
    }

    public static void scheduleUploads(UUID buildId, List<Path> localImagePaths) {
        for (Path path : localImagePaths) {
            UPLOAD_QUEUE.add(new FileKey(buildId, path.getFileName().toString()));
        }
        if (!isUploading) {
            ClientImageTransferManager.processUploadQueue();
        }
    }

    private static void processUploadQueue() {
        if (UPLOAD_QUEUE.isEmpty()) {
            isUploading = false;
            return;
        }
        isUploading = true;
        FileKey key = UPLOAD_QUEUE.poll();
        Path localPath = ClientImageTransferManager.getLocalImagePath(key.buildId, key.filename);
        if (Files.notExists(localPath, new LinkOption[0])) {
            Buildnotes.LOGGER.warn("Tried to upload non-existent local image: {}", (Object)localPath);
            ClientImageTransferManager.processUploadQueue();
            return;
        }
        Buildnotes.LOGGER.info("Starting upload for image: {}", (Object)localPath);
        CompletableFuture.runAsync(() -> {
            try {
                byte[] fullData = Files.readAllBytes(localPath);
                int totalChunks = (int)Math.ceil((double)fullData.length / 24576.0);
                for (int i = 0; i < totalChunks; ++i) {
                    int offset = i * 24576;
                    int length = Math.min(24576, fullData.length - offset);
                    byte[] chunkData = new byte[length];
                    System.arraycopy(fullData, offset, chunkData, 0, length);
                    ClientPlayNetworking.send((class_8710)new UploadImageChunkC2SPacket(key.buildId, key.filename, totalChunks, i, chunkData));
                }
                Buildnotes.LOGGER.info("Finished sending {} chunks for image '{}'", (Object)totalChunks, (Object)key.filename);
            }
            catch (IOException e) {
                Buildnotes.LOGGER.error("Failed to read and chunk local image for upload: {}", (Object)localPath, (Object)e);
            }
        }).thenRun(ClientImageTransferManager::processUploadQueue);
    }

    private record FileKey(UUID buildId, String filename) {
    }

    private static class ImageAssembler {
        private final byte[][] chunks;
        private int receivedChunks = 0;

        ImageAssembler(int totalChunks) {
            this.chunks = new byte[totalChunks][];
        }

        public boolean addChunk(int index, byte[] data) {
            if (index < this.chunks.length && this.chunks[index] == null) {
                this.chunks[index] = data;
                ++this.receivedChunks;
            }
            return this.isComplete();
        }

        public boolean isComplete() {
            return this.receivedChunks == this.chunks.length;
        }

        public byte[] reassemble() {
            int totalSize = 0;
            for (byte[] chunk : this.chunks) {
                if (chunk == null) {
                    return null;
                }
                totalSize += chunk.length;
            }
            byte[] fullData = new byte[totalSize];
            int currentPos = 0;
            for (byte[] chunk : this.chunks) {
                System.arraycopy(chunk, 0, fullData, currentPos, chunk.length);
                currentPos += chunk.length;
            }
            return fullData;
        }
    }
}

