/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.atif.buildnotes.client.ClientImageTransferManager;
import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.CustomField;
import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.data.Scope;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.screen.EditBuildScreen;
import net.atif.buildnotes.gui.screen.ScrollableScreen;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.ReadOnlyMultiLineTextFieldWidget;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class ViewBuildScreen
extends ScrollableScreen {
    private final Build build;
    private int currentImageIndex = 0;
    private final Map<String, ImageData> textureCache = new HashMap<String, ImageData>();
    private final Set<String> downloadingImages = new HashSet<String>();
    private DarkButtonWidget prevImageButton;
    private DarkButtonWidget nextImageButton;

    public ViewBuildScreen(class_437 parent, Build build) {
        super((class_2561)class_2561.method_43470((String)build.getName()), parent);
        this.build = build;
    }

    @Override
    protected int getTopMargin() {
        return 20;
    }

    @Override
    protected int getBottomMargin() {
        return 44;
    }

    @Override
    protected void initContent() {
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int yPos = this.getTopMargin();
        ReadOnlyMultiLineTextFieldWidget titleArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, contentX, yPos + 5, contentWidth, 25, this.field_22785.getString(), 1, false);
        this.addScrollableWidget(titleArea);
        int fieldWidth = (contentWidth - 5) / 2;
        int coordsTextX = contentX + 50;
        ReadOnlyMultiLineTextFieldWidget coordsArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, coordsTextX, yPos += 30, fieldWidth - 50, 20, this.build.getCoordinates(), 1, false);
        this.addScrollableWidget(coordsArea);
        int dimensionX = contentX + fieldWidth + 5;
        int dimensionTextX = dimensionX + 65;
        ReadOnlyMultiLineTextFieldWidget dimensionArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, dimensionTextX, yPos, fieldWidth - 65, 20, this.build.getDimension(), 1, false);
        this.addScrollableWidget(dimensionArea);
        yPos += 25;
        if (!this.build.getImageFileNames().isEmpty()) {
            int galleryHeight = (int)((double)contentWidth * 0.5625);
            yPos += galleryHeight + 5;
        }
        ReadOnlyMultiLineTextFieldWidget descriptionArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, contentX, yPos + 12, contentWidth, 120, this.build.getDescription(), Integer.MAX_VALUE, true);
        this.addScrollableWidget(descriptionArea);
        ReadOnlyMultiLineTextFieldWidget creditsArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, contentX, (yPos += 137) + 12, contentWidth, 60, this.build.getCredits(), Integer.MAX_VALUE, true);
        this.addScrollableWidget(creditsArea);
        yPos += 77;
        for (CustomField field : this.build.getCustomFields()) {
            ReadOnlyMultiLineTextFieldWidget fieldArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, contentX, yPos + 12, contentWidth, 60, field.getContent(), Integer.MAX_VALUE, true);
            this.addScrollableWidget(fieldArea);
            yPos += 77;
        }
        this.totalContentHeight = yPos;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        boolean canEdit = this.build.getScope() != Scope.SERVER || ClientSession.hasEditPermission();
        int buttonsY = UIHelper.getBottomButtonY(this);
        UIHelper.createButtonRow((class_437)this, buttonsY, 3, x -> {
            int idx = (x - UIHelper.getCenteredButtonStartX(this.field_22789, 3)) / 78;
            switch (idx) {
                case 0: {
                    DarkButtonWidget deleteButton = new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)class_2561.method_43471((String)"gui.buildnotes.delete_button"), button -> this.confirmDelete());
                    deleteButton.field_22763 = canEdit;
                    this.method_37063((class_364)deleteButton);
                    break;
                }
                case 1: {
                    DarkButtonWidget editButton = new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)class_2561.method_43471((String)"gui.buildnotes.edit_button"), button -> this.open(new EditBuildScreen(this.parent, this.build)));
                    editButton.field_22763 = canEdit;
                    this.method_37063((class_364)editButton);
                    break;
                }
                case 2: {
                    this.method_37063((class_364)new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)class_2561.method_43471((String)"gui.buildnotes.close_button"), button -> this.open(this.parent)));
                }
            }
        });
        if (!this.build.getImageFileNames().isEmpty()) {
            int contentWidth = (int)((double)this.field_22789 * 0.6);
            int contentX = (this.field_22789 - contentWidth) / 2;
            int galleryHeight = (int)((double)contentWidth * 0.5625);
            int galleryY = this.getTopMargin() + 25 + 5 + 20 + 5;
            int navButtonY = galleryY + (galleryHeight - 20) / 2;
            this.prevImageButton = new DarkButtonWidget(contentX - 25, navButtonY, 20, 20, (class_2561)class_2561.method_43470((String)"<"), b -> this.switchImage(-1));
            this.nextImageButton = new DarkButtonWidget(contentX + contentWidth + 5, navButtonY, 20, 20, (class_2561)class_2561.method_43470((String)">"), b -> this.switchImage(1));
            this.addScrollableWidget(this.prevImageButton);
            this.addScrollableWidget(this.nextImageButton);
            this.updateNavButtons();
        }
    }

    @Override
    protected void renderContent(class_332 context, int mouseX, int mouseY, float delta) {
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int yPos = this.getTopMargin();
        UIHelper.drawPanel(context, contentX, yPos, contentWidth, 25);
        int fieldWidth = (contentWidth - 5) / 2;
        UIHelper.drawPanel(context, contentX, yPos += 30, fieldWidth, 20);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Coords: ").method_27692(class_124.field_1080), contentX + 4, (int)((float)yPos + 6.0f + 1.0f), Colors.TEXT_MUTED, false);
        int dimensionX = contentX + fieldWidth + 5;
        UIHelper.drawPanel(context, dimensionX, yPos, fieldWidth, 20);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Dimension: ").method_27692(class_124.field_1080), dimensionX + 4, (int)((float)yPos + 6.0f + 1.0f), Colors.TEXT_MUTED, false);
        yPos += 25;
        if (!this.build.getImageFileNames().isEmpty()) {
            int galleryBoxHeight = (int)((double)contentWidth * 0.5625);
            UIHelper.drawPanel(context, contentX, yPos, contentWidth, galleryBoxHeight);
            String currentImageName = this.build.getImageFileNames().get(this.currentImageIndex);
            if (this.downloadingImages.contains(currentImageName)) {
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Loading image...").method_27692(class_124.field_1054), this.field_22789 / 2, yPos + galleryBoxHeight / 2 - 4, Colors.TEXT_PRIMARY);
            } else {
                ImageData data = this.getImageDataForCurrentImage();
                if (data != null && data.textureId != null) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)data.textureId);
                    RenderSystem.enableBlend();
                    int boxWidth = contentWidth - 4;
                    int boxHeight = galleryBoxHeight - 4;
                    float imageAspect = (float)data.width / (float)data.height;
                    float boxAspect = (float)boxWidth / (float)boxHeight;
                    int renderWidth = boxWidth;
                    int renderHeight = boxHeight;
                    if (imageAspect > boxAspect) {
                        renderHeight = (int)((float)boxWidth / imageAspect);
                    } else {
                        renderWidth = (int)((float)boxHeight * imageAspect);
                    }
                    int renderX = contentX + 2 + (boxWidth - renderWidth) / 2;
                    int renderY = yPos + 2 + (boxHeight - renderHeight) / 2;
                    context.method_25290(class_1921::method_62277, data.textureId, renderX, renderY, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight);
                    RenderSystem.disableBlend();
                } else {
                    context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Error or missing image").method_27692(class_124.field_1061), this.field_22789 / 2, yPos + galleryBoxHeight / 2 - 4, Colors.TEXT_PRIMARY);
                }
            }
            String counter = this.currentImageIndex + 1 + " / " + this.build.getImageFileNames().size();
            int counterWidth = this.field_22793.method_1727(counter);
            context.method_51433(this.field_22793, counter, contentX + contentWidth - counterWidth - 5, yPos + galleryBoxHeight - 12, Colors.TEXT_PRIMARY, false);
            yPos += galleryBoxHeight + 5;
        }
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Description:").method_27692(class_124.field_1080), contentX, yPos, Colors.TEXT_PRIMARY, false);
        UIHelper.drawPanel(context, contentX, yPos + 12, contentWidth, 120);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Credits:").method_27692(class_124.field_1080), contentX, yPos += 137, Colors.TEXT_PRIMARY, false);
        UIHelper.drawPanel(context, contentX, yPos + 12, contentWidth, 60);
        yPos += 77;
        for (CustomField field : this.build.getCustomFields()) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)(field.getTitle() + ":")).method_27692(class_124.field_1080), contentX, yPos, Colors.TEXT_PRIMARY, false);
            UIHelper.drawPanel(context, contentX, yPos + 12, contentWidth, 60);
            yPos += 77;
        }
    }

    private void switchImage(int direction) {
        int newIndex = this.currentImageIndex + direction;
        if (newIndex >= 0 && newIndex < this.build.getImageFileNames().size()) {
            this.currentImageIndex = newIndex;
            this.updateNavButtons();
        }
    }

    private void updateNavButtons() {
        if (this.prevImageButton != null) {
            boolean bl = this.prevImageButton.field_22763 = this.currentImageIndex > 0;
        }
        if (this.nextImageButton != null) {
            this.nextImageButton.field_22763 = this.currentImageIndex < this.build.getImageFileNames().size() - 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImageData getImageDataForCurrentImage() {
        if (this.build.getImageFileNames().isEmpty()) {
            return null;
        }
        String fileName = this.build.getImageFileNames().get(this.currentImageIndex);
        if (this.textureCache.containsKey(fileName)) {
            return this.textureCache.get(fileName);
        }
        try {
            Path imagePath = FabricLoader.getInstance().getConfigDir().resolve("buildnotes").resolve("images").resolve(this.build.getId().toString()).resolve(fileName);
            if (Files.exists(imagePath, new LinkOption[0])) {
                try (InputStream stream = Files.newInputStream(imagePath, new OpenOption[0]);){
                    class_1011 image = class_1011.method_4309((InputStream)stream);
                    class_1043 texture = new class_1043(image);
                    class_2960 textureId = this.field_22787.method_1531().method_4617("buildnotes_image_" + String.valueOf(this.build.getId()) + "_" + fileName.hashCode(), texture);
                    ImageData data = new ImageData(textureId, image.method_4307(), image.method_4323());
                    this.textureCache.put(fileName, data);
                    ImageData imageData = data;
                    return imageData;
                }
            }
            boolean isDedicatedServer = this.field_22787 != null && !this.field_22787.method_1496();
            if (this.build.getScope() != Scope.SERVER) return null;
            if (!isDedicatedServer) return null;
            if (this.downloadingImages.contains(fileName)) return null;
            this.downloadingImages.add(fileName);
            ClientImageTransferManager.requestImage(this.build.getId(), fileName, () -> this.field_22787.execute(() -> this.downloadingImages.remove(fileName)));
            return null;
        }
        catch (Exception e) {
            this.textureCache.put(fileName, null);
            return null;
        }
    }

    private void confirmDelete() {
        Runnable onConfirm = () -> {
            DataManager.getInstance().deleteBuild(this.build);
            this.method_25419();
        };
        this.showConfirm((class_2561)class_2561.method_43470((String)("Delete build \"" + this.build.getName() + "\"?")), onConfirm);
    }

    @Override
    public void method_25419() {
        this.textureCache.values().forEach(data -> {
            if (data != null && data.textureId != null) {
                this.field_22787.method_1531().method_4615(data.textureId);
            }
        });
        super.method_25419();
    }

    private record ImageData(class_2960 textureId, int width, int height) {
    }
}

