package net.atif.buildnotes.gui.widget.list;

import com.mojang.blaze3d.systems.RenderSystem;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.minecraft.class_1109;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_6382;

public abstract class AbstractListWidget<E extends AbstractListWidget.Entry<E>> extends class_350<E> {

    protected final MainScreen parentScreen;
    private boolean field_22764 = false;
    private static final int FADE_HEIGHT = 12;

    // double-click tracking
    private long lastClickTime = 0L;
    private E lastClickedEntry = null;
    private static final long DOUBLE_CLICK_MS = 250L;

    private boolean isDraggingScrollbar = false;
    private static final int SCROLLBAR_WIDTH = 6;
    private double scrollbarDragStartMouseY;

    public AbstractListWidget(MainScreen parent, class_310 client, int top, int bottom, int itemHeight) {
        // We pass the parent's width and height to the super constructor.
        super(client, parent.field_22789, bottom - top, top, itemHeight);

        this.parentScreen = parent;

        super.method_25315(false, 0);

    }

    // --- SHARED VISIBILITY LOGIC ---
    public void setVisible(boolean visible) {
        this.field_22764 = visible;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.field_22764) return false;

        if (this.method_25405(mouseX, mouseY) && mouseX >= this.method_57718() && mouseX < this.method_57718() + SCROLLBAR_WIDTH) {
            this.isDraggingScrollbar = true;
            this.scrollbarDragStartMouseY = mouseY;
            return true;
        }
        this.isDraggingScrollbar = false;
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        isDraggingScrollbar = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar) {
            int trackHeight = this.method_25364();
            float maxScroll = this.method_25331();
            float thumbHeight = Math.max(10, (float)(trackHeight * trackHeight) / (float)this.method_25317());
            float draggableHeight = trackHeight - thumbHeight;

            if (draggableHeight <= 0) return true; // Cannot drag if thumb fills the track

            // Calculate the ratio of scrollable content to draggable area
            float ratio = maxScroll / draggableHeight;

            // Update scroll amount based on mouse movement since the drag started
            double relativeMouseY = mouseY - this.scrollbarDragStartMouseY;
            this.method_25307(this.method_25341() + (relativeMouseY * ratio));

            // Update the start position for the next frame's calculation
            this.scrollbarDragStartMouseY = mouseY;

            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && super.method_25405(mouseX, mouseY);
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22764) return;


        // --- START SCISSORING (clip area so content doesn't render above or below list) ---
        double scale = class_310.method_1551().method_22683().method_4495();

        // Convert logical screen coordinates to framebuffer coordinates
        int scissorX = (int) (0 * scale);
        int scissorY = (int) (this.field_22740.method_22683().method_4506() - (this.method_55443() * scale));
        int scissorWidth = (int) (this.field_22758 * scale);
        int scissorHeight = (int) ((this.method_55443() - this.method_46427()) * scale);

        RenderSystem.enableScissor(scissorX, scissorY, scissorWidth, scissorHeight);

        super.method_48579(context, mouseX, mouseY, delta);
        renderCustomScrollbar(context); // We call this instead of relying on super's scrollbar

        RenderSystem.disableScissor();  // turn off clipping to draw the fade overlays properly

        // Save the current state
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();

        // Top fade overlay
        int left = this.method_46426();
        int right = this.method_55442();
        int topY = this.method_46427();
        drawVerticalGradient(context, left, topY, right, topY + FADE_HEIGHT,
                Colors.FADE_GRADIENT_TOP, Colors.FADE_GRADIENT_BOTTOM);  // semi-transparent black to transparent

        int bottomY = this.method_55443() - FADE_HEIGHT;
        drawVerticalGradient(context, left, bottomY, right, this.method_55443(), Colors.FADE_GRADIENT_BOTTOM, Colors.FADE_GRADIENT_TOP);

        RenderSystem.disableBlend();
    }

    @Override
    protected void method_57715(class_332 context) {
    }

    @Override
    protected void method_57713(class_332 context) {
    }

    protected void renderCustomScrollbar(class_332 context) {
        int maxScroll = this.method_25331();
        if (maxScroll <= 0) return; // Don't render if not scrollable

        int scrollbarX = this.method_57718();
        int trackHeight = this.method_25364();

        float thumbHeight = Math.max(10, (float)(trackHeight * trackHeight) / (float)this.method_25317());

        float maxThumbY = trackHeight - thumbHeight;

        float thumbY = (float)this.method_25341() / (float)maxScroll * maxThumbY;

        thumbY = Math.min(thumbY, maxThumbY);

        int thumbColor = isDraggingScrollbar ? Colors.SCROLLBAR_THUMB_ACTIVE : Colors.SCROLLBAR_THUMB_INACTIVE;

        context.method_25294(scrollbarX, this.method_46427() + (int) thumbY, scrollbarX + SCROLLBAR_WIDTH, this.method_46427() + (int) (thumbY + thumbHeight), thumbColor);
    }

    private void drawVerticalGradient(class_332 context, int x1, int y1, int x2, int y2, int topColor, int bottomColor) {
        context.method_25296(x1, y1, x2, y2, topColor, bottomColor);
    }

    // --- SHARED LAYOUT METHODS ---
    @Override
    public int method_25322() {
        // Make the list entries 3/5 of the screen's width.
        return (int) (this.parentScreen.field_22789 * 0.6);
    }

    @Override
    protected int method_57718() {
        int listWidth = method_25322();
        int xStart = (this.field_22758 - listWidth) / 2; // center the list
        return xStart + listWidth + 4; // small padding from edge
    }


    // --- SHARED UTILITY OVERRIDES ---
    @Override
    public void method_47399(class_6382 builder) {
        // We don't need narrations for this UI.
    }

    protected void handleEntryClick(E entry) {
        long now = System.currentTimeMillis();
        if (entry == this.lastClickedEntry && (now - this.lastClickTime) <= DOUBLE_CLICK_MS) {
            class_310.method_1551().method_1483().method_4873(
                    class_1109.method_47978(class_3417.field_15015, 1.0F)
            );

            // double click detected
            if (this.parentScreen != null) {
                this.parentScreen.openSelected();
            }
            // reset to avoid triple click detection
            this.lastClickedEntry = null;
            this.lastClickTime = 0L;
            return;
        }
        // not a double click, register this as the last click
        this.lastClickedEntry = entry;
        this.lastClickTime = now;
    }

    public static abstract class Entry<E extends Entry<E>> extends class_350.class_351<E> {
    }

}