/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.helper;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import net.atif.buildnotes.data.ColorConfig;

public final class Colors {
    public static int PANEL_BACKGROUND = 0x77000000;
    public static int TEXT_PRIMARY = -1;
    public static int TEXT_MUTED = -3355444;
    public static int TEXT_DISABLED = -7829368;
    public static int SELECTION_BACKGROUND = -2007651619;
    public static int CARET_PRIMARY = -1;
    public static int BUTTON_DISABLED = 0x44000000;
    public static int BUTTON_HOVER = -1442840576;
    public static int TAB_INACTIVE = 0x44000000;
    public static int SCROLLBAR_THUMB_INACTIVE = -1996488705;
    public static int SCROLLBAR_THUMB_ACTIVE = -1;
    public static int GRADIENT_START = -1072689136;
    public static int GRADIENT_END = -804253680;
    public static int FADE_GRADIENT_TOP = 0x60000000;
    public static int FADE_GRADIENT_BOTTOM = 0;

    private Colors() {
    }

    public static void reload() {
        ColorConfig.loadColors();
    }

    public static Map<String, String> getColorsAsMap() {
        LinkedHashMap<String, String> colorMap = new LinkedHashMap<String, String>();
        for (Field field : Colors.class.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getType() != Integer.TYPE) continue;
            try {
                int colorValue = (Integer)field.get(null);
                int a = colorValue >> 24 & 0xFF;
                int r = colorValue >> 16 & 0xFF;
                int g = colorValue >> 8 & 0xFF;
                int b = colorValue & 0xFF;
                float alpha = (float)a / 255.0f;
                colorMap.put(field.getName(), String.format("rgba(%d, %d, %d, %.3f)", r, g, b, Float.valueOf(alpha)));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return colorMap;
    }
}

