/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.network;

import java.util.List;
import java.util.UUID;
import net.atif.buildnotes.Buildnotes;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.data.PermissionLevel;
import net.atif.buildnotes.network.packet.c2s.DeleteBuildC2SPacket;
import net.atif.buildnotes.network.packet.c2s.DeleteNoteC2SPacket;
import net.atif.buildnotes.network.packet.c2s.RequestDataC2SPacket;
import net.atif.buildnotes.network.packet.c2s.RequestImageC2SPacket;
import net.atif.buildnotes.network.packet.c2s.SaveBuildC2SPacket;
import net.atif.buildnotes.network.packet.c2s.SaveNoteC2SPacket;
import net.atif.buildnotes.network.packet.c2s.UploadImageChunkC2SPacket;
import net.atif.buildnotes.network.packet.s2c.DeleteBuildS2CPacket;
import net.atif.buildnotes.network.packet.s2c.DeleteNoteS2CPacket;
import net.atif.buildnotes.network.packet.s2c.InitialSyncS2CPacket;
import net.atif.buildnotes.network.packet.s2c.UpdateBuildS2CPacket;
import net.atif.buildnotes.network.packet.s2c.UpdateNoteS2CPacket;
import net.atif.buildnotes.network.packet.s2c.UpdatePermissionS2CPacket;
import net.atif.buildnotes.server.ServerDataManager;
import net.atif.buildnotes.server.ServerImageTransferManager;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class ServerPacketHandler {
    private static boolean hasEditPermission(MinecraftServer server, class_3222 player) {
        return Buildnotes.PERMISSION_MANAGER.isAllowedToEdit(player);
    }

    public static void handleRequestInitialData(MinecraftServer server, class_3222 player, RequestDataC2SPacket packet) {
        ServerDataManager dataManager = Buildnotes.SERVER_DATA_MANAGER;
        List<Note> notes = dataManager.getNotes();
        List<Build> builds = dataManager.getBuilds();
        ServerPlayNetworking.send((class_3222)player, (class_8710)new InitialSyncS2CPacket(notes, builds));
    }

    public static void refreshPlayerPermissions(class_3222 player) {
        if (player == null) {
            return;
        }
        boolean canEdit = Buildnotes.PERMISSION_MANAGER.isAllowedToEdit(player);
        PermissionLevel level = canEdit ? PermissionLevel.CAN_EDIT : PermissionLevel.VIEW_ONLY;
        ServerPlayNetworking.send((class_3222)player, (class_8710)new UpdatePermissionS2CPacket(level));
    }

    public static void handleSaveNote(MinecraftServer server, class_3222 player, SaveNoteC2SPacket packet) {
        Note receivedNote = packet.note();
        if (!ServerPacketHandler.hasEditPermission(server, player)) {
            return;
        }
        Buildnotes.SERVER_DATA_MANAGER.saveNote(receivedNote);
        for (class_3222 p : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)new UpdateNoteS2CPacket(receivedNote));
        }
    }

    public static void handleSaveBuild(MinecraftServer server, class_3222 player, SaveBuildC2SPacket packet) {
        Build receivedBuild = packet.build();
        if (!ServerPacketHandler.hasEditPermission(server, player)) {
            return;
        }
        Buildnotes.SERVER_DATA_MANAGER.saveBuild(receivedBuild);
        for (class_3222 p : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)new UpdateBuildS2CPacket(receivedBuild));
        }
    }

    public static void handleDeleteNote(MinecraftServer server, class_3222 player, DeleteNoteC2SPacket packet) {
        UUID noteId = packet.noteId();
        if (!ServerPacketHandler.hasEditPermission(server, player)) {
            return;
        }
        Buildnotes.SERVER_DATA_MANAGER.deleteNote(noteId);
        for (class_3222 p : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)new DeleteNoteS2CPacket(noteId));
        }
    }

    public static void handleDeleteBuild(MinecraftServer server, class_3222 player, DeleteBuildC2SPacket packet) {
        UUID buildId = packet.buildId();
        if (!ServerPacketHandler.hasEditPermission(server, player)) {
            return;
        }
        Buildnotes.SERVER_DATA_MANAGER.deleteBuild(buildId);
        for (class_3222 p : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)new DeleteBuildS2CPacket(buildId));
        }
    }

    public static void handleImageChunkUpload(MinecraftServer server, class_3222 player, UploadImageChunkC2SPacket packet) {
        UUID buildId = packet.buildId();
        String filename = packet.filename();
        int totalChunks = packet.totalChunks();
        int chunkIndex = packet.chunkIndex();
        byte[] data = packet.data();
        ServerImageTransferManager.handleChunk(player, buildId, filename, totalChunks, chunkIndex, data);
    }

    public static void handleImageRequest(MinecraftServer server, class_3222 player, RequestImageC2SPacket packet) {
        UUID buildId = packet.buildId();
        String filename = packet.filename();
        Buildnotes.SERVER_DATA_MANAGER.sendImageToPlayer(player, buildId, filename);
    }
}

