/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.server;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import net.atif.buildnotes.Buildnotes;
import net.minecraft.class_3222;

public class ServerImageTransferManager {
    private static final Map<UUID, Map<TransferKey, ImageAssembler>> IN_PROGRESS_UPLOADS = Maps.newConcurrentMap();

    public static void handleChunk(class_3222 player, UUID buildId, String filename, int totalChunks, int chunkIndex, byte[] data) {
        UUID playerId = player.method_5667();
        IN_PROGRESS_UPLOADS.computeIfAbsent(playerId, k -> Maps.newHashMap());
        Map<TransferKey, ImageAssembler> playerUploads = IN_PROGRESS_UPLOADS.get(playerId);
        TransferKey key = new TransferKey(buildId, filename);
        ImageAssembler assembler = playerUploads.computeIfAbsent(key, k -> new ImageAssembler(totalChunks));
        if (assembler.addChunk(chunkIndex, data)) {
            byte[] fullImageData = assembler.reassemble();
            ServerImageTransferManager.saveImage(buildId, filename, fullImageData);
            playerUploads.remove(key);
            Buildnotes.LOGGER.info("Successfully received image '{}' for build {}", (Object)filename, (Object)buildId);
        }
    }

    private static void saveImage(UUID buildId, String filename, byte[] data) {
        try {
            Path destDir = Buildnotes.SERVER_DATA_MANAGER.getImageStoragePath(buildId);
            Files.createDirectories(destDir, new FileAttribute[0]);
            Path destPath = destDir.resolve(filename);
            Files.write(destPath, data, new OpenOption[0]);
        }
        catch (IOException e) {
            Buildnotes.LOGGER.error("Failed to save server-side image {} for build {}", new Object[]{filename, buildId, e});
        }
    }

    public static void onPlayerDisconnect(UUID playerId) {
        int discarded = 0;
        if (IN_PROGRESS_UPLOADS.containsKey(playerId)) {
            discarded = IN_PROGRESS_UPLOADS.get(playerId).size();
            IN_PROGRESS_UPLOADS.remove(playerId);
        }
        if (discarded > 0) {
            Buildnotes.LOGGER.warn("Discarded {} incomplete image uploads for disconnected player {}", (Object)discarded, (Object)playerId);
        }
    }

    private record TransferKey(UUID buildId, String filename) {
    }

    private static class ImageAssembler {
        private final byte[][] chunks;
        private int receivedChunks = 0;

        ImageAssembler(int totalChunks) {
            this.chunks = new byte[totalChunks][];
        }

        public boolean addChunk(int index, byte[] data) {
            if (index < this.chunks.length && this.chunks[index] == null) {
                this.chunks[index] = data;
                ++this.receivedChunks;
            }
            return this.isComplete();
        }

        public boolean isComplete() {
            return this.receivedChunks == this.chunks.length;
        }

        public byte[] reassemble() {
            int totalSize = 0;
            for (byte[] chunk : this.chunks) {
                totalSize += chunk.length;
            }
            byte[] fullData = new byte[totalSize];
            int currentPos = 0;
            for (byte[] chunk : this.chunks) {
                System.arraycopy(chunk, 0, fullData, currentPos, chunk.length);
                currentPos += chunk.length;
            }
            return fullData;
        }
    }
}

