/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.server.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import net.atif.buildnotes.Buildnotes;
import net.atif.buildnotes.server.PermissionEntry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;

public class BuildNotesCommands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> BuildNotesCommands.register((CommandDispatcher<class_2168>)dispatcher));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"buildnotes").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"allow").then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(BuildNotesCommands::allowPlayer)))).then(class_2170.method_9247((String)"disallow").then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(BuildNotesCommands::disallowPlayer)))).then(class_2170.method_9247((String)"list").executes(BuildNotesCommands::listPlayers))).then(class_2170.method_9247((String)"allow_all").then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(BuildNotesCommands::allowAll))));
    }

    private static int allowPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection profiles = class_2191.method_9330(context, (String)"players");
        class_2168 source = (class_2168)context.getSource();
        ArrayList<String> addedPlayers = new ArrayList<String>();
        ArrayList<String> alreadyAllowedPlayers = new ArrayList<String>();
        for (GameProfile profile : profiles) {
            if (Buildnotes.PERMISSION_MANAGER.addPlayer(profile)) {
                addedPlayers.add(profile.getName());
                continue;
            }
            alreadyAllowedPlayers.add(profile.getName());
        }
        if (!addedPlayers.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"Added ").method_10852((class_2561)class_2561.method_43470((String)String.join((CharSequence)", ", addedPlayers)).method_27692(class_124.field_1060)).method_27693(" to the BuildNotes editor list."), true);
        }
        if (!alreadyAllowedPlayers.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)(String.join((CharSequence)", ", alreadyAllowedPlayers) + " were already on the list.")));
        }
        return addedPlayers.size();
    }

    private static int disallowPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection profiles = class_2191.method_9330(context, (String)"players");
        class_2168 source = (class_2168)context.getSource();
        ArrayList<String> removedPlayers = new ArrayList<String>();
        ArrayList<String> notOnListPlayers = new ArrayList<String>();
        for (GameProfile profile : profiles) {
            if (Buildnotes.PERMISSION_MANAGER.removePlayer(profile)) {
                removedPlayers.add(profile.getName());
                continue;
            }
            notOnListPlayers.add(profile.getName());
        }
        if (!removedPlayers.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"Removed ").method_10852((class_2561)class_2561.method_43470((String)String.join((CharSequence)", ", removedPlayers)).method_27692(class_124.field_1061)).method_27693(" from the BuildNotes editor list."), true);
        }
        if (!notOnListPlayers.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)(String.join((CharSequence)", ", notOnListPlayers) + " were not on the list.")));
        }
        return removedPlayers.size();
    }

    private static int listPlayers(CommandContext<class_2168> context) {
        Set<PermissionEntry> allowedPlayers;
        class_2168 source = (class_2168)context.getSource();
        boolean allowAll = Buildnotes.PERMISSION_MANAGER.getAllowAll();
        if (allowAll) {
            source.method_9226(() -> class_2561.method_43470((String)"Note: 'allow_all' is currently TRUE. All players can edit.").method_27692(class_124.field_1065), false);
        }
        if ((allowedPlayers = Buildnotes.PERMISSION_MANAGER.getAllowedPlayers()).isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"There are no players on the BuildNotes editor list."), false);
            return 1;
        }
        String playerNames = allowedPlayers.stream().map(PermissionEntry::getName).collect(Collectors.joining(", "));
        source.method_9226(() -> class_2561.method_43470((String)"BuildNotes Editors: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)playerNames)), false);
        return allowedPlayers.size();
    }

    private static int allowAll(CommandContext<class_2168> context) {
        boolean enabled = BoolArgumentType.getBool(context, (String)"enabled");
        class_2168 source = (class_2168)context.getSource();
        Buildnotes.PERMISSION_MANAGER.setAllowAll(enabled);
        if (enabled) {
            source.method_9226(() -> class_2561.method_43470((String)"All players can now edit BuildNotes.").method_27692(class_124.field_1060), true);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"Only players on the list (and OPs) can edit BuildNotes.").method_27692(class_124.field_1061), true);
        }
        return 1;
    }
}

