/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.data.undoredo;

import java.util.Stack;
import net.atif.buildnotes.data.undoredo.TextAction;
import net.atif.buildnotes.data.undoredo.UndoableAction;
import net.atif.buildnotes.gui.widget.MultiLineTextFieldWidget;

public class UndoManager {
    private final Stack<UndoableAction> undoStack = new Stack();
    private final Stack<UndoableAction> redoStack = new Stack();
    private final MultiLineTextFieldWidget widget;

    public UndoManager(MultiLineTextFieldWidget widget) {
        this.widget = widget;
    }

    public void perform(TextAction action) {
        int cursor = this.widget.getCursorAbsolute();
        int selStart = this.widget.getSelectionStartAbsolute();
        int selEnd = this.widget.getSelectionEndAbsolute();
        this.undoStack.push(new UndoableAction(action, cursor, selStart, selEnd));
        this.redoStack.clear();
        action.execute();
    }

    public void undo() {
        if (!this.undoStack.isEmpty()) {
            UndoableAction undoableAction = this.undoStack.pop();
            this.redoStack.push(undoableAction);
            undoableAction.action().undo();
            this.widget.setCursorFromAbsolute(undoableAction.cursorBefore());
            this.widget.setSelectionAbsolute(undoableAction.selectionStartBefore(), undoableAction.selectionEndBefore());
        }
    }

    public void redo() {
        if (!this.redoStack.isEmpty()) {
            UndoableAction undoableAction = this.redoStack.pop();
            this.undoStack.push(undoableAction);
            undoableAction.action().execute();
        }
    }
}

