/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.helper;

import java.util.List;
import java.util.function.Consumer;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.screen.ConfirmScreen;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class UIHelper {
    public static final int MIN_BUTTON_WIDTH = 70;
    public static final int BUTTON_WIDTH = 70;
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTON_SPACING = 8;
    public static final int OUTER_PADDING = 12;
    public static final int BUTTON_ROW_SPACING = 6;
    public static final int BUTTON_TEXT_PADDING = 10;

    public static void drawPanel(class_4587 matrices, int x, int y, int width, int height) {
        class_332.method_25294((class_4587)matrices, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)Colors.PANEL_BACKGROUND);
    }

    public static int getCenteredButtonStartX(int screenWidth, int buttonCount) {
        int totalWidth = buttonCount * 70 + (buttonCount - 1) * 8;
        return (screenWidth - totalWidth) / 2;
    }

    public static void createButtonRow(class_437 screen, int y, int buttonCount, Consumer<Integer> buttonCreator) {
        int startX = UIHelper.getCenteredButtonStartX(screen.field_22789, buttonCount);
        for (int i = 0; i < buttonCount; ++i) {
            int buttonX = startX + i * 78;
            buttonCreator.accept(buttonX);
        }
    }

    public static void createButtonRow(class_437 screen, int y, List<class_2561> buttonTexts, DynamicButtonCreator creator) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (buttonTexts.isEmpty()) {
            return;
        }
        int[] widths = new int[buttonTexts.size()];
        int totalWidth = 0;
        for (int i = 0; i < buttonTexts.size(); ++i) {
            int textWidth = textRenderer.method_27525((class_5348)buttonTexts.get(i)) + 20;
            widths[i] = Math.max(textWidth, 70);
            totalWidth += widths[i];
        }
        int currentX = (screen.field_22789 - (totalWidth += 8 * (buttonTexts.size() - 1))) / 2;
        for (int i = 0; i < buttonTexts.size(); ++i) {
            creator.create(i, currentX, widths[i]);
            currentX += widths[i] + 8;
        }
    }

    public static int getBottomButtonY(class_437 screen) {
        return screen.field_22790 - 12 - 20;
    }

    public static int getBottomButtonY(class_437 screen, int row) {
        if (row == 1) {
            return screen.field_22790 - 12 - 20 - 6 - 20;
        }
        return screen.field_22790 - 12 - 20;
    }

    public static void showConfirmDialog(class_437 parent, class_2561 message, Runnable onConfirm) {
        class_310.method_1551().method_1507((class_437)new ConfirmScreen(parent, message, onConfirm, () -> class_310.method_1551().method_1507(parent)));
    }

    @FunctionalInterface
    public static interface DynamicButtonCreator {
        public void create(int var1, int var2, int var3);
    }
}

