/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.widget.list;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.atif.buildnotes.gui.widget.list.AbstractListWidget;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class BuildListWidget
extends AbstractListWidget<BuildEntry> {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");

    public BuildListWidget(MainScreen parent, class_310 client, int top, int bottom, int itemHeight) {
        super(parent, client, top, bottom, itemHeight);
    }

    public void setBuilds(List<Build> builds) {
        this.method_25339();
        builds.forEach(build -> this.method_25321(new BuildEntry((Build)build)));
    }

    public Build getSelectedBuild() {
        BuildEntry entry = (BuildEntry)this.method_25334();
        return entry != null ? entry.getBuild() : null;
    }

    public void setSelected(BuildEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.parentScreen.onBuildSelected();
    }

    public class BuildEntry
    extends class_350.class_351<BuildEntry> {
        private final Build build;
        private final String formattedDateTime;

        public BuildEntry(Build build) {
            this.build = build;
            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(build.getLastModified()), ZoneId.systemDefault());
            this.formattedDateTime = dateTime.format(DATE_TIME_FORMATTER);
        }

        public Build getBuild() {
            return this.build;
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_5250 scopeText = null;
            int scopeWidth = 0;
            if (this.build.getScope() != null) {
                switch (this.build.getScope()) {
                    case GLOBAL: {
                        scopeText = class_2561.method_43470((String)"Global").method_27692(class_124.field_1075);
                        break;
                    }
                    case SERVER: {
                        scopeText = class_2561.method_43470((String)"Server").method_27692(class_124.field_1060);
                    }
                }
            }
            if (scopeText != null) {
                scopeWidth = ((BuildListWidget)BuildListWidget.this).field_22740.field_1772.method_27525(scopeText);
            }
            int availableNameWidth = entryWidth - 6;
            if (scopeText != null) {
                availableNameWidth -= scopeWidth + 7;
            }
            String truncatedName = ((BuildListWidget)BuildListWidget.this).field_22740.field_1772.method_27523(this.build.getName(), availableNameWidth);
            ((BuildListWidget)BuildListWidget.this).field_22740.field_1772.method_1729(matrices, truncatedName, (float)(x + 2), (float)(y + 2), Colors.TEXT_PRIMARY);
            if (scopeText != null) {
                ((BuildListWidget)BuildListWidget.this).field_22740.field_1772.method_30883(matrices, (class_2561)scopeText, (float)(x + entryWidth - scopeWidth - 6), (float)(y + 2), Colors.TEXT_PRIMARY);
            }
            String fullCoordsText = "Coords: " + this.build.getCoordinates();
            String truncatedCoords = ((BuildListWidget)BuildListWidget.this).field_22740.field_1772.method_27523(fullCoordsText, entryWidth - 6);
            ((BuildListWidget)BuildListWidget.this).field_22740.field_1772.method_30883(matrices, (class_2561)class_2561.method_43470((String)truncatedCoords).method_27692(class_124.field_1080), (float)(x + 2), (float)(y + 12), Colors.TEXT_MUTED);
            String fullDateText = "Last Modified: " + this.formattedDateTime;
            String truncatedDate = ((BuildListWidget)BuildListWidget.this).field_22740.field_1772.method_27523(fullDateText, entryWidth - 6);
            ((BuildListWidget)BuildListWidget.this).field_22740.field_1772.method_1729(matrices, truncatedDate, (float)(x + 2), (float)(y + 22), Colors.TEXT_MUTED);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                BuildListWidget.this.setSelected(this);
                BuildListWidget.this.handleEntryClick(this);
                return true;
            }
            return false;
        }
    }
}

