package net.atif.buildnotes.network;

import net.atif.buildnotes.client.ClientCache;
import net.atif.buildnotes.client.ClientImageTransferManager;
import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.data.PermissionLevel;
import net.atif.buildnotes.gui.screen.MainScreen; // ADDED
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_634;
import java.util.List;
import java.util.UUID;

public class ClientPacketHandler {

    private static void refreshMainScreen(class_310 client) {
        if (client.field_1755 instanceof MainScreen) {
            ((MainScreen) client.field_1755).refreshData();
        }
    }

    public static void handleInitialSync(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        List<Note> notes = buf.method_34066(Note::fromBuf);
        List<Build> builds = buf.method_34066(Build::fromBuf);
        client.execute(() -> {
            ClientCache.setNotes(notes);
            ClientCache.setBuilds(builds);
            // After the very first sync, refresh the screen if it's open
            refreshMainScreen(client);
        });
    }

    public static void handleUpdatePermission(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        // Read the enum from the buffer
        PermissionLevel newLevel = buf.method_10818(PermissionLevel.class);

        client.execute(() -> {
            // Update session
            ClientSession.updatePermissionLevel(newLevel);
            refreshMainScreen(client);
        });
    }

    public static void handleUpdateNote(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        Note updatedNote = Note.fromBuf(buf);
        client.execute(() -> {
            ClientCache.addOrUpdateNote(updatedNote);
            refreshMainScreen(client);
        });
    }

    public static void handleUpdateBuild(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        Build updatedBuild = Build.fromBuf(buf);
        client.execute(() -> {
            ClientCache.addOrUpdateBuild(updatedBuild);
            refreshMainScreen(client);
        });
    }

    public static void handleDeleteNote(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        UUID noteId = buf.method_10790();
        client.execute(() -> {
            ClientCache.removeNoteById(noteId);
            refreshMainScreen(client);
        });
    }

    public static void handleDeleteBuild(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        UUID buildId = buf.method_10790();
        client.execute(() -> {
            ClientCache.removeBuildById(buildId);
            refreshMainScreen(client);
        });
    }

    public static void handleImageChunk(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        // Read the data in the same order the server wrote it
        UUID buildId = buf.method_10790();
        String filename = buf.method_19772();
        int totalChunks = buf.method_10816();
        int chunkIndex = buf.method_10816();
        byte[] data = buf.method_10795();

        // Pass the data to the manager on the client thread to ensure thread safety
        client.execute(() -> ClientImageTransferManager.handleChunk(buildId, filename, totalChunks, chunkIndex, data));
    }

    public static void handleImageNotFound(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        UUID buildId = buf.method_10790();
        String filename = buf.method_19772();
        client.execute(() -> ClientImageTransferManager.onDownloadFailed(buildId, filename));
    }
}