package net.atif.buildnotes.data;

import java.util.UUID;
import net.minecraft.class_2540;

public class Note extends BaseEntry {
    private String title;
    private String content;

    // Keep the main constructor you already had
    public Note(String title, String content) {
        super();
        this.title = title;
        this.content = content;
    }

    private Note(UUID id, long lastModified, Scope scope, String title, String content) {
        super(id, lastModified, scope); // Passes the existing data up
        this.title = title;
        this.content = content;
    }

    // Getters
    public String getTitle() { return title; }
    public String getContent() { return content; }

    // Setters
    public void setTitle(String title) { this.title = title; }
    public void setContent(String content) { this.content = content; }

    public void writeToBuf(class_2540 buf) {
        buf.method_10797(this.getId());
        buf.method_52974(this.getLastModified());
        buf.method_10817(this.getScope());
        buf.method_10814(this.title);
        buf.method_10814(this.content);
    }

    public static Note fromBuf(class_2540 buf) {
        UUID id = buf.method_10790();
        long lastModified = buf.readLong();
        Scope scope = buf.method_10818(Scope.class);
        String title = buf.method_19772();
        String content = buf.method_19772();

        return new Note(id, lastModified, scope, title, content);
    }
}
