package net.atif.buildnotes.gui.screen;

import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.gui.helper.NoteScreenLayouts;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.ReadOnlyMultiLineTextFieldWidget;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class ViewNoteScreen extends BaseScreen {

    private final Note note;

    private ReadOnlyMultiLineTextFieldWidget titleArea;
    private ReadOnlyMultiLineTextFieldWidget contentArea;

    public ViewNoteScreen(class_437 parent, Note note) {
        super(class_2561.method_43471(note.getTitle()), parent);
        this.note = note;
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        int buttonsY = UIHelper.getBottomButtonY(this);
        UIHelper.createButtonRow(this, buttonsY, 3, x -> {
            int idx = (x - UIHelper.getCenteredButtonStartX(this.field_22789, 3)) / (UIHelper.BUTTON_WIDTH + UIHelper.BUTTON_SPACING);
            switch (idx) {
                case 0 -> this.method_37063(new DarkButtonWidget(x, buttonsY, UIHelper.BUTTON_WIDTH, UIHelper.BUTTON_HEIGHT,
                        class_2561.method_43471("gui.buildnotes.delete_button"), button -> confirmDelete()));
                case 1 -> this.method_37063(new DarkButtonWidget(x, buttonsY, UIHelper.BUTTON_WIDTH, UIHelper.BUTTON_HEIGHT,
                        class_2561.method_43471("gui.buildnotes.edit_button"), button -> this.field_22787.method_1507(new EditNoteScreen(this.parent, this.note))));
                case 2 -> this.method_37063(new DarkButtonWidget(x, buttonsY, UIHelper.BUTTON_WIDTH, UIHelper.BUTTON_HEIGHT,
                        class_2561.method_43471("gui.buildnotes.close_button"), button -> this.field_22787.method_1507(parent)));
            }
        });

        int contentWidth = (int) (this.field_22789 * NoteScreenLayouts.CONTENT_WIDTH_RATIO);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int bottomMargin = NoteScreenLayouts.getBottomMarginSingleRow();

        // --- Title Widget ---
        this.titleArea = new ReadOnlyMultiLineTextFieldWidget(
                this.field_22793,
                contentX,
                NoteScreenLayouts.TOP_MARGIN + 5,
                contentWidth,
                NoteScreenLayouts.TITLE_PANEL_HEIGHT,
                this.note.getTitle(),
                1,
                false
        );
        this.method_25429(this.titleArea);

        int contentPanelY = NoteScreenLayouts.TOP_MARGIN + NoteScreenLayouts.TITLE_PANEL_HEIGHT + NoteScreenLayouts.PANEL_SPACING;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        int contentPanelHeight = contentPanelBottom - contentPanelY;

        // --- Content Widget ---
        this.contentArea = new ReadOnlyMultiLineTextFieldWidget(
                this.field_22793,
                contentX,
                contentPanelY,
                contentWidth,
                contentPanelHeight,
                note.getContent(),
                Integer.MAX_VALUE,
                true
        );
        this.method_25429(this.contentArea);
    }

    private void confirmDelete() {
        Runnable onConfirm = () -> {
            DataManager.getInstance().deleteNote(this.note);
            this.method_25419();
        };
        UIHelper.showConfirmDialog(this, class_2561.method_43471("Delete note \"" + note.getTitle() + "\"?"), onConfirm);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);

        int contentWidth = (int) (this.field_22789 * NoteScreenLayouts.CONTENT_WIDTH_RATIO);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int bottomMargin = NoteScreenLayouts.getBottomMarginSingleRow();

        // --- Title Panel ---
        UIHelper.drawPanel(context, contentX, NoteScreenLayouts.TOP_MARGIN, contentWidth, NoteScreenLayouts.TITLE_PANEL_HEIGHT);
        this.titleArea.method_25394(context, mouseX, mouseY, delta);

        // --- Content Panel ---
        int contentPanelY = NoteScreenLayouts.TOP_MARGIN + NoteScreenLayouts.TITLE_PANEL_HEIGHT + NoteScreenLayouts.PANEL_SPACING;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        UIHelper.drawPanel(context, contentX, contentPanelY, contentWidth, contentPanelBottom - contentPanelY);
        this.contentArea.method_25394(context, mouseX, mouseY, delta);
    }

    @Override
    public boolean method_25404(class_11908 input) {
        if (this.titleArea.method_25404(input)) return true;
        if (this.contentArea.method_25404(input)) return true;
        return super.method_25404(input);
    }

    // --- Delegate scrolling to the widget ---
    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        // Pass scroll events to the widget under the mouse
        if (this.titleArea.method_25405(mouseX, mouseY)) {
            return this.titleArea.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        if (this.contentArea.method_25405(mouseX, mouseY)) {
            return this.contentArea.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return false;
    }

}