/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.screen;

import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.data.Scope;
import net.atif.buildnotes.gui.helper.NoteScreenLayouts;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.screen.BaseScreen;
import net.atif.buildnotes.gui.screen.EditNoteScreen;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.ReadOnlyMultiLineTextFieldWidget;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class ViewNoteScreen
extends BaseScreen {
    private final Note note;
    private ReadOnlyMultiLineTextFieldWidget titleArea;
    private ReadOnlyMultiLineTextFieldWidget contentArea;

    public ViewNoteScreen(class_437 parent, Note note) {
        super((class_2561)class_2561.method_43471((String)note.getTitle()), parent);
        this.note = note;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        boolean canEdit = this.note.getScope() != Scope.SERVER || ClientSession.hasEditPermission();
        int buttonsY = UIHelper.getBottomButtonY(this);
        UIHelper.createButtonRow((class_437)this, buttonsY, 3, x -> {
            int idx = (x - UIHelper.getCenteredButtonStartX(this.field_22789, 3)) / 78;
            switch (idx) {
                case 0: {
                    DarkButtonWidget deleteButton = new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)class_2561.method_43471((String)"gui.buildnotes.delete_button"), button -> this.confirmDelete());
                    deleteButton.field_22763 = canEdit;
                    this.method_37063((class_364)deleteButton);
                    break;
                }
                case 1: {
                    DarkButtonWidget editButton = new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)class_2561.method_43471((String)"gui.buildnotes.edit_button"), button -> this.field_22787.method_1507((class_437)new EditNoteScreen(this.parent, this.note)));
                    editButton.field_22763 = canEdit;
                    this.method_37063((class_364)editButton);
                    break;
                }
                case 2: {
                    this.method_37063((class_364)new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)class_2561.method_43471((String)"gui.buildnotes.close_button"), button -> this.field_22787.method_1507(this.parent)));
                }
            }
        });
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int bottomMargin = NoteScreenLayouts.getBottomMarginSingleRow();
        this.titleArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, contentX, 25, contentWidth, 25, this.note.getTitle(), 1, false);
        this.method_25429(this.titleArea);
        int contentPanelY = 50;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        int contentPanelHeight = contentPanelBottom - contentPanelY;
        this.contentArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, contentX, contentPanelY, contentWidth, contentPanelHeight, this.note.getContent(), Integer.MAX_VALUE, true);
        this.method_25429(this.contentArea);
    }

    private void confirmDelete() {
        Runnable onConfirm = () -> {
            DataManager.getInstance().deleteNote(this.note);
            this.method_25419();
        };
        UIHelper.showConfirmDialog(this, (class_2561)class_2561.method_43471((String)("Delete note \"" + this.note.getTitle() + "\"?")), onConfirm);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int bottomMargin = NoteScreenLayouts.getBottomMarginSingleRow();
        UIHelper.drawPanel(context, contentX, 20, contentWidth, 25);
        this.titleArea.method_25394(context, mouseX, mouseY, delta);
        int contentPanelY = 50;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        UIHelper.drawPanel(context, contentX, contentPanelY, contentWidth, contentPanelBottom - contentPanelY);
        this.contentArea.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.titleArea.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.contentArea.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.titleArea.method_25405(mouseX, mouseY)) {
            return this.titleArea.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        if (this.contentArea.method_25405(mouseX, mouseY)) {
            return this.contentArea.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.method_25399() != null && this.method_25397() && button == 0) {
            this.method_25398(false);
            return this.method_25399().method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }
}

