/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.widget.list;

import com.mojang.blaze3d.systems.RenderSystem;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_6382;
import net.minecraft.class_6880;

public abstract class AbstractListWidget<E extends Entry<E>>
extends class_350<E> {
    protected final MainScreen parentScreen;
    private boolean visible = false;
    private static final int FADE_HEIGHT = 12;
    private long lastClickTime = 0L;
    private E lastClickedEntry = null;
    private static final long DOUBLE_CLICK_MS = 250L;
    private boolean isDraggingScrollbar = false;
    private static final int SCROLLBAR_WIDTH = 6;
    private double scrollbarDragStartMouseY;

    public AbstractListWidget(MainScreen parent, class_310 client, int top, int bottom, int itemHeight) {
        super(client, parent.field_22789, bottom - top, top, itemHeight);
        this.parentScreen = parent;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        if (this.method_25405(mouseX, mouseY) && mouseX >= (double)this.method_57718() && mouseX < (double)(this.method_57718() + 6)) {
            this.isDraggingScrollbar = true;
            this.scrollbarDragStartMouseY = mouseY;
            return true;
        }
        this.isDraggingScrollbar = false;
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar) {
            int trackHeight = this.method_25364();
            float maxScroll = this.method_25331();
            float thumbHeight = Math.max(10.0f, (float)(trackHeight * trackHeight) / (float)this.method_25317());
            float draggableHeight = (float)trackHeight - thumbHeight;
            if (draggableHeight <= 0.0f) {
                return true;
            }
            float ratio = maxScroll / draggableHeight;
            double relativeMouseY = mouseY - this.scrollbarDragStartMouseY;
            this.method_25307(this.method_25341() + relativeMouseY * (double)ratio);
            this.scrollbarDragStartMouseY = mouseY;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.visible && super.method_25405(mouseX, mouseY);
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        double scale = class_310.method_1551().method_22683().method_4495();
        int scissorX = (int)(0.0 * scale);
        int scissorY = (int)((double)this.field_22740.method_22683().method_4506() - (double)this.method_55443() * scale);
        int scissorWidth = (int)((double)this.field_22758 * scale);
        int scissorHeight = (int)((double)(this.method_55443() - this.method_46427()) * scale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
        super.method_48579(context, mouseX, mouseY, delta);
        this.renderCustomScrollbar(context);
        RenderSystem.disableScissor();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int left = this.method_46426();
        int right = this.method_55442();
        int topY = this.method_46427();
        this.drawVerticalGradient(context, left, topY, right, topY + 12, Colors.FADE_GRADIENT_TOP, Colors.FADE_GRADIENT_BOTTOM);
        int bottomY = this.method_55443() - 12;
        this.drawVerticalGradient(context, left, bottomY, right, this.method_55443(), Colors.FADE_GRADIENT_BOTTOM, Colors.FADE_GRADIENT_TOP);
        RenderSystem.disableBlend();
    }

    protected void method_57715(class_332 context) {
    }

    protected void method_57713(class_332 context) {
    }

    protected void renderCustomScrollbar(class_332 context) {
        int maxScroll = this.method_25331();
        if (maxScroll <= 0) {
            return;
        }
        int scrollbarX = this.method_57718();
        int trackHeight = this.method_25364();
        float thumbHeight = Math.max(10.0f, (float)(trackHeight * trackHeight) / (float)this.method_25317());
        float maxThumbY = (float)trackHeight - thumbHeight;
        float thumbY = (float)this.method_25341() / (float)maxScroll * maxThumbY;
        thumbY = Math.min(thumbY, maxThumbY);
        int thumbColor = this.isDraggingScrollbar ? Colors.SCROLLBAR_THUMB_ACTIVE : Colors.SCROLLBAR_THUMB_INACTIVE;
        context.method_25294(scrollbarX, this.method_46427() + (int)thumbY, scrollbarX + 6, this.method_46427() + (int)(thumbY + thumbHeight), thumbColor);
    }

    private void drawVerticalGradient(class_332 context, int x1, int y1, int x2, int y2, int topColor, int bottomColor) {
        context.method_25296(x1, y1, x2, y2, topColor, bottomColor);
    }

    public int method_25322() {
        return (int)((double)this.parentScreen.field_22789 * 0.6);
    }

    protected int method_57718() {
        int listWidth = this.method_25322();
        int xStart = (this.field_22758 - listWidth) / 2;
        return xStart + listWidth + 4;
    }

    public void method_47399(class_6382 builder) {
    }

    protected void handleEntryClick(E entry) {
        long now = System.currentTimeMillis();
        if (entry == this.lastClickedEntry && now - this.lastClickTime <= 250L) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            if (this.parentScreen != null) {
                this.parentScreen.openSelected();
            }
            this.lastClickedEntry = null;
            this.lastClickTime = 0L;
            return;
        }
        this.lastClickedEntry = entry;
        this.lastClickTime = now;
    }

    public static abstract class Entry<E extends Entry<E>>
    extends class_350.class_351<E> {
    }
}

