/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.atif.buildnotes.client.ClientImageTransferManager;
import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.CustomField;
import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.data.Scope;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.screen.BaseScreen;
import net.atif.buildnotes.gui.screen.ScrollableScreen;
import net.atif.buildnotes.gui.screen.ViewBuildScreen;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.MultiLineTextFieldWidget;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class EditBuildScreen
extends ScrollableScreen {
    private final Build build;
    private int currentImageIndex = 0;
    private final Map<String, ImageData> textureCache = new HashMap<String, ImageData>();
    private final Set<String> downloadingImages = new HashSet<String>();
    private DarkButtonWidget prevImageButton;
    private DarkButtonWidget nextImageButton;
    private MultiLineTextFieldWidget nameField;
    private MultiLineTextFieldWidget coordsField;
    private MultiLineTextFieldWidget dimensionField;
    private MultiLineTextFieldWidget descriptionField;
    private MultiLineTextFieldWidget designerField;
    private final Map<CustomField, MultiLineTextFieldWidget> customFieldWidgets = new LinkedHashMap<CustomField, MultiLineTextFieldWidget>();
    private MultiLineTextFieldWidget lastFocusedTextField;

    public EditBuildScreen(class_437 parent, Build build) {
        super((class_2561)new class_2588("gui.buildnotes.edit_build_title"), parent);
        this.build = build;
    }

    @Override
    protected int getTopMargin() {
        return 20;
    }

    @Override
    protected int getBottomMargin() {
        return 70;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int bottomRowY = UIHelper.getBottomButtonY(this, 2);
        List<class_2588> bottomTexts = List.of(new class_2588("gui.buildnotes.save_button"), new class_2588("gui.buildnotes.close_button"));
        UIHelper.createButtonRow((class_437)this, bottomRowY, bottomTexts, (index, x, width) -> {
            if (index == 0) {
                this.method_37063((class_364)new DarkButtonWidget(x, bottomRowY, width, 20, (class_2561)bottomTexts.get(0), button -> {
                    this.saveBuild();
                    this.open(new ViewBuildScreen(this.parent, this.build));
                }));
            } else {
                this.method_37063((class_364)new DarkButtonWidget(x, bottomRowY, width, 20, (class_2561)bottomTexts.get(1), button -> this.method_25419()));
            }
        });
        int topRowY = UIHelper.getBottomButtonY(this, 1);
        List<class_2561> topTexts = List.of(new class_2588("gui.buildnotes.edit.coords"), new class_2588("gui.buildnotes.edit.dimension"), new class_2588("gui.buildnotes.edit.biome"), new class_2588("gui.buildnotes.edit.add_images"), new class_2588("gui.buildnotes.edit.add_field"), this.getScopeButtonText());
        UIHelper.createButtonRow((class_437)this, topRowY, topTexts, (index, x, width) -> {
            switch (index) {
                case 0: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topTexts.get(0), b -> this.insertCoords()));
                    break;
                }
                case 1: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topTexts.get(1), b -> this.insertDimension()));
                    break;
                }
                case 2: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topTexts.get(2), b -> this.insertBiome()));
                    break;
                }
                case 3: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topTexts.get(3), b -> this.openImageSelectionDialog()));
                    break;
                }
                case 4: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topTexts.get(4), b -> {
                        this.saveBuild();
                        this.open(new RequestFieldTitleScreen(this, this::addCustomField));
                    }));
                    break;
                }
                case 5: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topTexts.get(5), button -> {
                        this.saveBuild();
                        this.cycleScope();
                        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                    }));
                }
            }
        });
        if (!this.build.getImageFileNames().isEmpty()) {
            int panelSpacing = 5;
            int contentWidth = (int)((double)this.field_22789 * 0.6);
            int contentX = (this.field_22789 - contentWidth) / 2;
            int galleryHeight = (int)((double)contentWidth * 0.5625);
            int galleryY = this.getTopMargin() + 25 + panelSpacing + 20 + panelSpacing;
            int navButtonY = galleryY + (galleryHeight - 20) / 2;
            this.prevImageButton = new DarkButtonWidget(contentX - 25, navButtonY, 20, 20, (class_2561)new class_2588("gui.buildnotes.gallery.previous"), b -> this.switchImage(-1));
            this.nextImageButton = new DarkButtonWidget(contentX + contentWidth + 5, navButtonY, 20, 20, (class_2561)new class_2588("gui.buildnotes.gallery.next"), b -> this.switchImage(1));
            DarkButtonWidget deleteImageButton = new DarkButtonWidget(contentX + contentWidth - 22, galleryY + 2, 20, 20, (class_2561)new class_2588("gui.buildnotes.gallery.delete"), b -> this.removeCurrentImage());
            this.addScrollableWidget(this.prevImageButton);
            this.addScrollableWidget(this.nextImageButton);
            this.addScrollableWidget(deleteImageButton);
            this.updateNavButtons();
        }
        this.method_20085(this.nameField);
    }

    @Override
    protected void initContent() {
        this.customFieldWidgets.clear();
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int yPos = this.getTopMargin();
        int panelSpacing = 5;
        this.nameField = new MultiLineTextFieldWidget(this.field_22793, contentX, yPos + 5, contentWidth, 25, this.build.getName(), new class_2588("gui.buildnotes.placeholder.build_name").getString(), 1, false);
        this.addScrollableWidget(this.nameField);
        int fieldWidth = (contentWidth - panelSpacing) / 2;
        this.coordsField = new MultiLineTextFieldWidget(this.field_22793, contentX + 50, yPos += 25 + panelSpacing, fieldWidth - 50, 20, this.build.getCoordinates(), new class_2588("gui.buildnotes.placeholder.coords").getString(), 1, false);
        this.addScrollableWidget(this.coordsField);
        int dimensionX = contentX + fieldWidth + panelSpacing;
        this.dimensionField = new MultiLineTextFieldWidget(this.field_22793, dimensionX + 65, yPos, fieldWidth - 65, 20, this.build.getDimension(), new class_2588("gui.buildnotes.placeholder.dimension").getString(), 1, false);
        this.addScrollableWidget(this.dimensionField);
        yPos += 20 + panelSpacing;
        if (!this.build.getImageFileNames().isEmpty()) {
            int galleryHeight = (int)((double)contentWidth * 0.5625);
            yPos += galleryHeight + panelSpacing;
        }
        this.descriptionField = new MultiLineTextFieldWidget(this.field_22793, contentX, yPos += 12, contentWidth, 120, this.build.getDescription(), new class_2588("gui.buildnotes.placeholder.description").getString(), Integer.MAX_VALUE, true);
        this.addScrollableWidget(this.descriptionField);
        yPos += 120 + panelSpacing;
        this.designerField = new MultiLineTextFieldWidget(this.field_22793, contentX, yPos += 12, contentWidth, 60, this.build.getCredits(), new class_2588("gui.buildnotes.placeholder.credits").getString(), Integer.MAX_VALUE, true);
        this.addScrollableWidget(this.designerField);
        yPos += 60 + panelSpacing;
        for (CustomField field : this.build.getCustomFields()) {
            int fieldWidgetWidth = contentWidth - 20 - panelSpacing;
            MultiLineTextFieldWidget fieldArea = new MultiLineTextFieldWidget(this.field_22793, contentX, yPos += 12, fieldWidgetWidth, 60, field.getContent(), "", Integer.MAX_VALUE, true);
            this.addScrollableWidget(fieldArea);
            this.customFieldWidgets.put(field, fieldArea);
            DarkButtonWidget removeButton = new DarkButtonWidget(contentX + fieldWidgetWidth + panelSpacing, yPos, 20, 20, (class_2561)new class_2588("gui.buildnotes.edit.remove_field"), button -> this.removeCustomField(field));
            this.addScrollableWidget(removeButton);
            yPos += 60 + panelSpacing;
        }
        this.totalContentHeight = yPos;
    }

    @Override
    protected void renderContent(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int yPos = this.getTopMargin();
        int panelSpacing = 5;
        UIHelper.drawPanel(matrices, contentX, yPos, contentWidth, 25);
        int fieldWidth = (contentWidth - panelSpacing) / 2;
        UIHelper.drawPanel(matrices, contentX, yPos += 25 + panelSpacing, fieldWidth, 20);
        this.field_22793.method_30883(matrices, (class_2561)new class_2588("gui.buildnotes.label.coords").method_27692(class_124.field_1080), (float)(contentX + 4), (float)yPos + 6.0f + 1.0f, Colors.TEXT_MUTED);
        int dimensionX = contentX + fieldWidth + panelSpacing;
        UIHelper.drawPanel(matrices, dimensionX, yPos, fieldWidth, 20);
        this.field_22793.method_30883(matrices, (class_2561)new class_2588("gui.buildnotes.label.dimension").method_27692(class_124.field_1080), (float)(dimensionX + 4), (float)yPos + 6.0f + 1.0f, Colors.TEXT_MUTED);
        yPos += 20 + panelSpacing;
        if (!this.build.getImageFileNames().isEmpty()) {
            int galleryBoxHeight = (int)((double)contentWidth * 0.5625);
            UIHelper.drawPanel(matrices, contentX, yPos, contentWidth, galleryBoxHeight);
            String currentImageName = this.build.getImageFileNames().get(this.currentImageIndex);
            if (this.downloadingImages.contains(currentImageName)) {
                EditBuildScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)new class_2588("gui.buildnotes.gallery.loading").method_27692(class_124.field_1054), (int)(this.field_22789 / 2), (int)(yPos + galleryBoxHeight / 2 - 4), (int)Colors.TEXT_PRIMARY);
            } else {
                ImageData data = this.getImageDataForCurrentImage();
                if (data != null && data.textureId != null) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)data.textureId);
                    RenderSystem.enableBlend();
                    int boxWidth = contentWidth - 4;
                    int boxHeight = galleryBoxHeight - 4;
                    float imageAspect = (float)data.width / (float)data.height;
                    float boxAspect = (float)boxWidth / (float)boxHeight;
                    int renderWidth = boxWidth;
                    int renderHeight = boxHeight;
                    if (imageAspect > boxAspect) {
                        renderHeight = (int)((float)boxWidth / imageAspect);
                    } else {
                        renderWidth = (int)((float)boxHeight * imageAspect);
                    }
                    int renderX = contentX + 2 + (boxWidth - renderWidth) / 2;
                    int renderY = yPos + 2 + (boxHeight - renderHeight) / 2;
                    class_332.method_25290((class_4587)matrices, (int)renderX, (int)renderY, (float)0.0f, (float)0.0f, (int)renderWidth, (int)renderHeight, (int)renderWidth, (int)renderHeight);
                    RenderSystem.disableBlend();
                } else {
                    EditBuildScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)new class_2588("gui.buildnotes.gallery.error").method_27692(class_124.field_1061), (int)(this.field_22789 / 2), (int)(yPos + galleryBoxHeight / 2 - 4), (int)Colors.TEXT_PRIMARY);
                }
            }
            String counter = this.currentImageIndex + 1 + " / " + this.build.getImageFileNames().size();
            int counterWidth = this.field_22793.method_1727(counter);
            this.field_22793.method_30883(matrices, class_2561.method_30163((String)counter), (float)(contentX + contentWidth - counterWidth - 5), (float)(yPos + galleryBoxHeight - 12), Colors.TEXT_PRIMARY);
            yPos += galleryBoxHeight + panelSpacing;
        }
        this.field_22793.method_30883(matrices, (class_2561)new class_2588("gui.buildnotes.label.description").method_27692(class_124.field_1080), (float)contentX, (float)yPos, Colors.TEXT_PRIMARY);
        UIHelper.drawPanel(matrices, contentX, yPos += 12, contentWidth, 120);
        this.field_22793.method_30883(matrices, (class_2561)new class_2588("gui.buildnotes.label.credits").method_27692(class_124.field_1080), (float)contentX, (float)(yPos += 120 + panelSpacing), Colors.TEXT_PRIMARY);
        UIHelper.drawPanel(matrices, contentX, yPos += 12, contentWidth, 60);
        yPos += 60 + panelSpacing;
        for (CustomField field : this.build.getCustomFields()) {
            this.field_22793.method_30883(matrices, (class_2561)new class_2588(field.getTitle() + ":").method_27692(class_124.field_1080), (float)contentX, (float)yPos, Colors.TEXT_PRIMARY);
            UIHelper.drawPanel(matrices, contentX, yPos += 12, contentWidth, 60);
            yPos += 60 + panelSpacing;
        }
        EditBuildScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)8, (int)Colors.TEXT_PRIMARY);
    }

    private void switchImage(int direction) {
        int newIndex = this.currentImageIndex + direction;
        if (newIndex >= 0 && newIndex < this.build.getImageFileNames().size()) {
            this.currentImageIndex = newIndex;
            this.updateNavButtons();
        }
    }

    private void removeCurrentImage() {
        if (this.build.getImageFileNames().isEmpty()) {
            return;
        }
        String fileNameToRemove = this.build.getImageFileNames().get(this.currentImageIndex);
        this.build.getImageFileNames().remove(fileNameToRemove);
        if (this.currentImageIndex >= this.build.getImageFileNames().size()) {
            this.currentImageIndex = Math.max(0, this.build.getImageFileNames().size() - 1);
        }
        this.rebuild();
    }

    private void updateNavButtons() {
        if (this.prevImageButton != null) {
            boolean bl = this.prevImageButton.field_22763 = this.currentImageIndex > 0;
        }
        if (this.nextImageButton != null) {
            this.nextImageButton.field_22763 = this.currentImageIndex < this.build.getImageFileNames().size() - 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImageData getImageDataForCurrentImage() {
        if (this.build.getImageFileNames().isEmpty()) {
            return null;
        }
        String fileName = this.build.getImageFileNames().get(this.currentImageIndex);
        if (this.textureCache.containsKey(fileName)) {
            return this.textureCache.get(fileName);
        }
        try {
            Path imagePath = FabricLoader.getInstance().getConfigDir().resolve("buildnotes").resolve("images").resolve(this.build.getId().toString()).resolve(fileName);
            if (Files.exists(imagePath, new LinkOption[0])) {
                try (InputStream stream = Files.newInputStream(imagePath, new OpenOption[0]);){
                    class_1011 image = class_1011.method_4309((InputStream)stream);
                    class_1043 texture = new class_1043(image);
                    class_2960 textureId = this.field_22787.method_1531().method_4617("buildnotes_image_" + String.valueOf(this.build.getId()) + "_" + fileName.hashCode(), texture);
                    ImageData data = new ImageData(textureId, image.method_4307(), image.method_4323());
                    this.textureCache.put(fileName, data);
                    ImageData imageData = data;
                    return imageData;
                }
            }
            boolean isDedicatedServer = this.field_22787 != null && !this.field_22787.method_1496();
            if (this.build.getScope() != Scope.SERVER) return null;
            if (!isDedicatedServer) return null;
            if (this.downloadingImages.contains(fileName)) return null;
            this.downloadingImages.add(fileName);
            ClientImageTransferManager.requestImage(this.build.getId(), fileName, () -> this.field_22787.execute(() -> this.downloadingImages.remove(fileName)));
            return null;
        }
        catch (Exception e) {
            this.textureCache.put(fileName, null);
            return null;
        }
    }

    @Override
    public void method_25419() {
        this.textureCache.values().forEach(data -> {
            if (data != null && data.textureId != null) {
                this.field_22787.method_1531().method_4615(data.textureId);
            }
        });
        this.saveBuild();
        super.method_25419();
    }

    private void rebuild() {
        this.saveBuild();
        this.open(new EditBuildScreen(this.parent, this.build));
    }

    private void saveBuild() {
        this.build.setName(this.nameField.getText());
        this.build.setCoordinates(this.coordsField.getText());
        this.build.setDimension(this.dimensionField.getText());
        this.build.setDescription(this.descriptionField.getText());
        this.build.setCredits(this.designerField.getText());
        for (Map.Entry<CustomField, MultiLineTextFieldWidget> entry : this.customFieldWidgets.entrySet()) {
            entry.getKey().setContent(entry.getValue().getText());
        }
        this.build.updateTimestamp();
        DataManager.getInstance().saveBuild(this.build);
    }

    private void insertTextAtLastFocus(String text) {
        if (this.lastFocusedTextField != null) {
            this.lastFocusedTextField.insertText(text);
            this.method_25395(this.lastFocusedTextField);
        } else if (this.descriptionField != null) {
            this.descriptionField.insertText(text);
            this.method_25395(this.descriptionField);
        }
    }

    private void insertCoords() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        String coords = String.format("%.0f, %.0f, %.0f", this.field_22787.field_1724.method_23317(), this.field_22787.field_1724.method_23318(), this.field_22787.field_1724.method_23321());
        this.insertTextAtLastFocus(coords);
    }

    private void insertDimension() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        String dim = this.field_22787.field_1724.field_6002.method_27983().method_29177().toString();
        this.insertTextAtLastFocus(dim);
    }

    private void insertBiome() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null || this.field_22787.field_1687 == null) {
            return;
        }
        class_2338 playerPos = this.field_22787.field_1724.method_24515();
        String biomeId = this.field_22787.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)((class_1959)this.field_22787.field_1687.method_23753(playerPos).comp_349())).toString();
        this.insertTextAtLastFocus(biomeId);
    }

    private void openImageSelectionDialog() {
        new Thread(() -> {
            String selectedFiles = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Select Image(s)", null, null, (CharSequence)"Image Files (*.png, *.jpg, *.jpeg)", (boolean)true);
            this.field_22787.execute(() -> {
                if (selectedFiles != null) {
                    this.processSelectedFiles(selectedFiles.split("\\|"));
                }
                if (this.field_22787 != null) {
                    long handle = this.field_22787.method_22683().method_4490();
                    GLFW.glfwRestoreWindow((long)handle);
                    GLFW.glfwFocusWindow((long)handle);
                }
            });
        }).start();
    }

    private void processSelectedFiles(String[] paths) {
        new Thread(() -> {
            for (String pathStr : paths) {
                try {
                    Path sourcePath = Path.of(pathStr, new String[0]);
                    String fileName = sourcePath.getFileName().toString().toLowerCase();
                    if (!fileName.endsWith(".png") && !fileName.endsWith(".jpg") && !fileName.endsWith(".jpeg")) continue;
                    Path destDir = FabricLoader.getInstance().getConfigDir().resolve("buildnotes").resolve("images").resolve(this.build.getId().toString());
                    Files.createDirectories(destDir, new FileAttribute[0]);
                    Path destPath = destDir.resolve(fileName);
                    Files.copy(sourcePath, destPath, StandardCopyOption.REPLACE_EXISTING);
                    if (this.build.getImageFileNames().contains(fileName)) continue;
                    this.build.getImageFileNames().add(fileName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.field_22787.execute(this::rebuild);
        }).start();
    }

    private void addCustomField(String title) {
        if (title == null || title.isBlank()) {
            return;
        }
        this.build.getCustomFields().add(new CustomField(title, ""));
        this.rebuild();
    }

    private void removeCustomField(CustomField field) {
        this.build.getCustomFields().remove(field);
        this.rebuild();
    }

    private void cycleScope() {
        Scope currentScope = this.build.getScope();
        if (ClientSession.isOnServer() && ClientSession.hasEditPermission()) {
            if (currentScope == Scope.WORLD) {
                this.build.setScope(Scope.GLOBAL);
            } else if (currentScope == Scope.GLOBAL) {
                this.build.setScope(Scope.SERVER);
            } else {
                this.build.setScope(Scope.WORLD);
            }
        } else {
            this.build.setScope(currentScope == Scope.WORLD ? Scope.GLOBAL : Scope.WORLD);
        }
    }

    private class_2561 getScopeButtonText() {
        Scope currentScope = this.build.getScope();
        class_2588 scopeName = currentScope == Scope.GLOBAL ? new class_2588("gui.buildnotes.edit.scope.global") : (currentScope == Scope.SERVER ? new class_2588("gui.buildnotes.edit.scope.server") : (this.field_22787 != null && this.field_22787.method_1496() ? new class_2588("gui.buildnotes.edit.scope.world") : new class_2588("gui.buildnotes.edit.scope.per_server")));
        return new class_2588("gui.buildnotes.edit.scope_button", new Object[]{scopeName});
    }

    public void method_25395(class_364 focused) {
        super.method_25395(focused);
        if (focused instanceof MultiLineTextFieldWidget) {
            MultiLineTextFieldWidget widget;
            this.lastFocusedTextField = widget = (MultiLineTextFieldWidget)focused;
        }
    }

    private record ImageData(class_2960 textureId, int width, int height) {
    }

    private static class RequestFieldTitleScreen
    extends BaseScreen {
        private final Consumer<String> onConfirm;
        private class_342 titleField;

        protected RequestFieldTitleScreen(class_437 parent, Consumer<String> onConfirm) {
            super((class_2561)new class_2588("gui.buildnotes.prompt.field_title"), parent);
            this.onConfirm = onConfirm;
        }

        @Override
        protected void method_25426() {
            super.method_25426();
            int panelH = 100;
            int panelW = 200;
            int panelX = (this.field_22789 - panelW) / 2;
            int panelY = (this.field_22790 - panelH) / 2;
            this.titleField = new class_342(this.field_22793, panelX + 10, panelY + 20, panelW - 20, 20, class_2561.method_30163((String)""));
            this.method_25429((class_364)this.titleField);
            List<class_2588> buttonTexts = List.of(new class_2588("gui.buildnotes.confirm_button"), new class_2588("gui.buildnotes.cancel_button"));
            int buttonsY = panelY + panelH - 20 - 12;
            UIHelper.createButtonRow((class_437)this, buttonsY, buttonTexts, (index, x, width) -> {
                if (index == 0) {
                    this.method_37063((class_364)new DarkButtonWidget(x, buttonsY, width, 20, (class_2561)buttonTexts.get(0), button -> {
                        this.onConfirm.accept(this.titleField.method_1882());
                        this.open(this.parent);
                    }));
                } else {
                    this.method_37063((class_364)new DarkButtonWidget(x, buttonsY, width, 20, (class_2561)buttonTexts.get(1), button -> this.open(this.parent)));
                }
            });
            this.method_20085((class_364)this.titleField);
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.method_25420(matrices);
            super.method_25394(matrices, mouseX, mouseY, delta);
            int panelW = 200;
            int panelH = 100;
            int panelX = (this.field_22789 - panelW) / 2;
            int panelY = (this.field_22790 - panelH) / 2;
            UIHelper.drawPanel(matrices, panelX, panelY, panelW, panelH -= 44);
            RequestFieldTitleScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)(panelY + 8), (int)Colors.TEXT_PRIMARY);
            this.titleField.method_25394(matrices, mouseX, mouseY, delta);
        }
    }
}

