/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.screen;

import java.util.List;
import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.data.Scope;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.helper.NoteScreenLayouts;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.screen.BaseScreen;
import net.atif.buildnotes.gui.screen.ViewNoteScreen;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.MultiLineTextFieldWidget;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class EditNoteScreen
extends BaseScreen {
    private final Note note;
    private MultiLineTextFieldWidget titleField;
    private MultiLineTextFieldWidget contentField;
    private MultiLineTextFieldWidget lastFocusedTextField;

    public EditNoteScreen(class_437 parent, Note note) {
        super((class_2561)new class_2588("gui.buildnotes.edit_note_title"), parent);
        this.note = note;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int bottomMargin = NoteScreenLayouts.getBottomMarginDoubleRow();
        this.titleField = new MultiLineTextFieldWidget(this.field_22793, contentX, 25, contentWidth, 25, this.note.getTitle(), new class_2588("gui.buildnotes.placeholder.title").getString(), 1, false);
        this.method_25429(this.titleField);
        int contentPanelY = 50;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        this.contentField = new MultiLineTextFieldWidget(this.field_22793, contentX, contentPanelY, contentWidth, contentPanelBottom - contentPanelY, this.note.getContent(), new class_2588("gui.buildnotes.placeholder.note_content").getString(), Integer.MAX_VALUE, true);
        this.method_25429(this.contentField);
        int topRowY = UIHelper.getBottomButtonY(this, 1);
        List<class_2561> topButtonTexts = List.of(new class_2588("gui.buildnotes.edit.coords"), new class_2588("gui.buildnotes.edit.biome"), this.getScopeButtonText());
        UIHelper.createButtonRow((class_437)this, topRowY, topButtonTexts, (index, x, width) -> {
            switch (index) {
                case 0: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topButtonTexts.get(0), b -> this.insertCoords()));
                    break;
                }
                case 1: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topButtonTexts.get(1), b -> this.insertBiome()));
                    break;
                }
                case 2: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topButtonTexts.get(2), b -> {
                        this.saveNote();
                        this.cycleScope();
                        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                    }));
                }
            }
        });
        int bottomRowY = UIHelper.getBottomButtonY(this, 2);
        List<class_2588> bottomButtonTexts = List.of(new class_2588("gui.buildnotes.save_button"), new class_2588("gui.buildnotes.close_button"));
        UIHelper.createButtonRow((class_437)this, bottomRowY, bottomButtonTexts, (index, x, width) -> {
            if (index == 0) {
                this.method_37063((class_364)new DarkButtonWidget(x, bottomRowY, width, 20, (class_2561)bottomButtonTexts.get(0), button -> {
                    this.saveNote();
                    this.open(new ViewNoteScreen(this.parent, this.note));
                }));
            } else {
                this.method_37063((class_364)new DarkButtonWidget(x, bottomRowY, width, 20, (class_2561)bottomButtonTexts.get(1), button -> this.method_25419()));
            }
        });
        this.method_20085(this.titleField);
    }

    private void cycleScope() {
        Scope currentScope = this.note.getScope();
        if (ClientSession.isOnServer() && ClientSession.hasEditPermission()) {
            if (currentScope == Scope.WORLD) {
                this.note.setScope(Scope.GLOBAL);
            } else if (currentScope == Scope.GLOBAL) {
                this.note.setScope(Scope.SERVER);
            } else {
                this.note.setScope(Scope.WORLD);
            }
        } else {
            this.note.setScope(currentScope == Scope.WORLD ? Scope.GLOBAL : Scope.WORLD);
        }
    }

    private class_2561 getScopeButtonText() {
        Scope currentScope = this.note.getScope();
        class_2588 scopeName = currentScope == Scope.GLOBAL ? new class_2588("gui.buildnotes.edit.scope.global") : (currentScope == Scope.SERVER ? new class_2588("gui.buildnotes.edit.scope.server") : (this.field_22787 != null && this.field_22787.method_1496() ? new class_2588("gui.buildnotes.edit.scope.world") : new class_2588("gui.buildnotes.edit.scope.per_server")));
        return new class_2588("gui.buildnotes.edit.scope_button", new Object[]{scopeName});
    }

    private void saveNote() {
        this.note.setTitle(this.titleField.getText());
        this.note.setContent(this.contentField.getText());
        this.note.updateTimestamp();
        DataManager.getInstance().saveNote(this.note);
    }

    private void insertTextAtLastFocus(String text) {
        if (this.lastFocusedTextField != null) {
            this.lastFocusedTextField.insertText(text);
            this.method_25395(this.lastFocusedTextField);
        } else if (this.contentField != null) {
            this.contentField.insertText(text);
            this.method_25395(this.contentField);
        }
    }

    private void insertCoords() {
        if (this.field_22787.field_1724 == null) {
            return;
        }
        String coords = String.format("X: %.0f, Y: %.0f, Z: %.0f", this.field_22787.field_1724.method_23317(), this.field_22787.field_1724.method_23318(), this.field_22787.field_1724.method_23321());
        this.insertTextAtLastFocus(coords);
    }

    private void insertBiome() {
        if (this.field_22787.field_1724 == null || this.field_22787.field_1687 == null) {
            return;
        }
        class_2338 playerPos = this.field_22787.field_1724.method_24515();
        String biomeId = this.field_22787.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)((class_1959)this.field_22787.field_1687.method_23753(playerPos).comp_349())).toString();
        this.insertTextAtLastFocus(biomeId);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int bottomMargin = NoteScreenLayouts.getBottomMarginDoubleRow();
        UIHelper.drawPanel(matrices, contentX, 20, contentWidth, 25);
        this.titleField.method_25394(matrices, mouseX, mouseY, delta);
        int contentPanelY = 50;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        UIHelper.drawPanel(matrices, contentX, contentPanelY, contentWidth, contentPanelBottom - contentPanelY);
        this.contentField.method_25394(matrices, mouseX, mouseY, delta);
        EditNoteScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)8, (int)Colors.TEXT_PRIMARY);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.contentField.method_25405(mouseX, mouseY)) {
            return this.contentField.method_25401(mouseX, mouseY, amount);
        }
        if (this.titleField.method_25405(mouseX, mouseY)) {
            return this.titleField.method_25401(mouseX, mouseY, amount);
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.method_25399() != null && this.method_25397() && button == 0) {
            this.method_25398(false);
            return this.method_25399().method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25395(class_364 focused) {
        super.method_25395(focused);
        if (focused instanceof MultiLineTextFieldWidget) {
            MultiLineTextFieldWidget widget;
            this.lastFocusedTextField = widget = (MultiLineTextFieldWidget)focused;
        }
    }

    @Override
    public void method_25419() {
        this.saveNote();
        super.method_25419();
    }
}

