/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.screen;

import java.util.List;
import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.data.Scope;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.helper.NoteScreenLayouts;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.screen.BaseScreen;
import net.atif.buildnotes.gui.screen.ViewNoteScreen;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.MultiLineTextFieldWidget;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class EditNoteScreen
extends BaseScreen {
    private final Note note;
    private MultiLineTextFieldWidget titleField;
    private MultiLineTextFieldWidget contentField;
    private MultiLineTextFieldWidget lastFocusedTextField;

    public EditNoteScreen(class_437 parent, Note note) {
        super((class_2561)class_2561.method_43471((String)"gui.buildnotes.edit_note_title"), parent);
        this.note = note;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int bottomMargin = NoteScreenLayouts.getBottomMarginDoubleRow();
        this.titleField = new MultiLineTextFieldWidget(this.field_22793, contentX, 25, contentWidth, 25, this.note.getTitle(), class_2561.method_43471((String)"gui.buildnotes.placeholder.title").getString(), 1, false);
        this.method_25429(this.titleField);
        int contentPanelY = 50;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        this.contentField = new MultiLineTextFieldWidget(this.field_22793, contentX, contentPanelY, contentWidth, contentPanelBottom - contentPanelY, this.note.getContent(), class_2561.method_43471((String)"gui.buildnotes.placeholder.note_content").getString(), Integer.MAX_VALUE, true);
        this.method_25429(this.contentField);
        int topRowY = UIHelper.getBottomButtonY(this, 1);
        List<class_2561> topButtonTexts = List.of(class_2561.method_43471((String)"gui.buildnotes.edit.coords"), class_2561.method_43471((String)"gui.buildnotes.edit.biome"), this.getScopeButtonText());
        UIHelper.createButtonRow((class_437)this, topRowY, topButtonTexts, (index, x, width) -> {
            switch (index) {
                case 0: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topButtonTexts.get(0), b -> this.insertCoords()));
                    break;
                }
                case 1: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topButtonTexts.get(1), b -> this.insertBiome()));
                    break;
                }
                case 2: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topButtonTexts.get(2), b -> {
                        this.saveNote();
                        this.cycleScope();
                        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                    }));
                }
            }
        });
        int bottomRowY = UIHelper.getBottomButtonY(this, 2);
        List<class_5250> bottomButtonTexts = List.of(class_2561.method_43471((String)"gui.buildnotes.save_button"), class_2561.method_43471((String)"gui.buildnotes.close_button"));
        UIHelper.createButtonRow((class_437)this, bottomRowY, bottomButtonTexts, (index, x, width) -> {
            if (index == 0) {
                this.method_37063((class_364)new DarkButtonWidget(x, bottomRowY, width, 20, (class_2561)bottomButtonTexts.get(0), button -> {
                    this.saveNote();
                    this.open(new ViewNoteScreen(this.parent, this.note));
                }));
            } else {
                this.method_37063((class_364)new DarkButtonWidget(x, bottomRowY, width, 20, (class_2561)bottomButtonTexts.get(1), button -> this.method_25419()));
            }
        });
        this.method_48265(this.titleField);
    }

    public void method_25393() {
        super.method_25393();
        if (this.titleField.method_25370()) {
            this.lastFocusedTextField = this.titleField;
        } else if (this.contentField.method_25370()) {
            this.lastFocusedTextField = this.contentField;
        }
    }

    private void cycleScope() {
        Scope currentScope = this.note.getScope();
        if (ClientSession.isOnServer() && ClientSession.hasEditPermission()) {
            if (currentScope == Scope.WORLD) {
                this.note.setScope(Scope.GLOBAL);
            } else if (currentScope == Scope.GLOBAL) {
                this.note.setScope(Scope.SERVER);
            } else {
                this.note.setScope(Scope.WORLD);
            }
        } else {
            this.note.setScope(currentScope == Scope.WORLD ? Scope.GLOBAL : Scope.WORLD);
        }
    }

    private class_2561 getScopeButtonText() {
        Scope currentScope = this.note.getScope();
        class_5250 scopeName = currentScope == Scope.GLOBAL ? class_2561.method_43471((String)"gui.buildnotes.edit.scope.global") : (currentScope == Scope.SERVER ? class_2561.method_43471((String)"gui.buildnotes.edit.scope.server") : (this.field_22787 != null && this.field_22787.method_1496() ? class_2561.method_43471((String)"gui.buildnotes.edit.scope.world") : class_2561.method_43471((String)"gui.buildnotes.edit.scope.per_server")));
        return class_2561.method_43469((String)"gui.buildnotes.edit.scope_button", (Object[])new Object[]{scopeName});
    }

    private void saveNote() {
        this.note.setTitle(this.titleField.getText());
        this.note.setContent(this.contentField.getText());
        this.note.updateTimestamp();
        DataManager.getInstance().saveNote(this.note);
    }

    private void insertTextAtLastFocus(String text) {
        if (this.lastFocusedTextField != null) {
            this.lastFocusedTextField.insertText(text);
            this.method_25395(this.lastFocusedTextField);
        } else if (this.contentField != null) {
            this.contentField.insertText(text);
            this.method_25395(this.contentField);
        }
    }

    private void insertCoords() {
        if (this.field_22787.field_1724 == null) {
            return;
        }
        String coords = String.format("X: %.0f, Y: %.0f, Z: %.0f", this.field_22787.field_1724.method_23317(), this.field_22787.field_1724.method_23318(), this.field_22787.field_1724.method_23321());
        this.insertTextAtLastFocus(coords);
    }

    private void insertBiome() {
        if (this.field_22787.field_1724 == null || this.field_22787.field_1687 == null) {
            return;
        }
        class_2338 playerPos = this.field_22787.field_1724.method_24515();
        class_6880 biomeEntry = this.field_22787.field_1687.method_23753(playerPos);
        String biomeId = biomeEntry.method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse("minecraft:unknown");
        this.insertTextAtLastFocus(biomeId);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int bottomMargin = NoteScreenLayouts.getBottomMarginDoubleRow();
        UIHelper.drawPanel(context, contentX, 20, contentWidth, 25);
        this.titleField.method_25394(context, mouseX, mouseY, delta);
        int contentPanelY = 50;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        UIHelper.drawPanel(context, contentX, contentPanelY, contentWidth, contentPanelBottom - contentPanelY);
        this.contentField.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, Colors.TEXT_PRIMARY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.contentField.method_25405(mouseX, mouseY)) {
            return this.contentField.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        if (this.titleField.method_25405(mouseX, mouseY)) {
            return this.titleField.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Override
    public void method_25419() {
        this.saveNote();
        super.method_25419();
    }
}

