/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.screen;

import com.google.common.collect.Lists;
import java.util.List;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.screen.BaseScreen;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import org.joml.Matrix3x2fStack;

public abstract class ScrollableScreen
extends BaseScreen {
    protected final List<class_364> scrollableWidgets = Lists.newArrayList();
    protected double scrollY = 0.0;
    protected int totalContentHeight = 0;
    private boolean isDraggingScrollbar = false;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int SCROLLBAR_PADDING = 2;

    protected ScrollableScreen(class_2561 title, class_437 parent) {
        super(title, parent);
    }

    protected abstract void initContent();

    protected abstract void renderContent(class_332 var1, int var2, int var3, float var4);

    protected abstract int getTopMargin();

    protected abstract int getBottomMargin();

    @Override
    protected void method_25426() {
        super.method_25426();
        this.scrollableWidgets.clear();
        this.scrollY = 0.0;
        this.initContent();
    }

    protected <T extends class_364 & class_6379> void addScrollableWidget(T widget) {
        this.scrollableWidgets.add(widget);
        this.method_25429(widget);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int top = this.getTopMargin();
        int bottom = this.field_22790 - this.getBottomMargin();
        if (bottom <= top) {
            return;
        }
        context.method_44379(0, top, this.field_22789, bottom);
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate(0.0f, (float)top);
        matrices.translate(0.0f, (float)(-this.scrollY));
        int adjustedMouseY = (int)((double)(mouseY - top) + this.scrollY);
        this.renderContent(context, mouseX, adjustedMouseY, delta);
        for (class_364 widget : this.scrollableWidgets) {
            if (!(widget instanceof class_4068)) continue;
            class_4068 drawable = (class_4068)widget;
            drawable.method_25394(context, mouseX, adjustedMouseY, delta);
        }
        matrices.popMatrix();
        context.method_44380();
        this.renderScrollbar(context);
    }

    private void renderScrollbar(class_332 context) {
        int top = this.getTopMargin();
        int bottom = this.field_22790 - this.getBottomMargin();
        int trackHeight = bottom - top;
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int scrollbarX = this.field_22789 - 6 - 2;
            float thumbHeight = Math.max(20.0f, (float)trackHeight / (float)this.totalContentHeight * (float)trackHeight);
            float thumbY = (float)(this.scrollY / (double)maxScroll * (double)((float)trackHeight - thumbHeight));
            int color = this.isDraggingScrollbar ? Colors.SCROLLBAR_THUMB_ACTIVE : Colors.SCROLLBAR_THUMB_INACTIVE;
            context.method_25294(scrollbarX, top + (int)thumbY, scrollbarX + 6, top + (int)(thumbY + thumbHeight), color);
        }
    }

    private int getMaxScroll() {
        int visibleHeight = this.field_22790 - this.getTopMargin() - this.getBottomMargin();
        return Math.max(0, this.totalContentHeight - visibleHeight);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int top = this.getTopMargin();
        int bottom = this.field_22790 - this.getBottomMargin();
        if (mouseY >= (double)top && mouseY < (double)bottom) {
            double adjustedMouseY = mouseY - (double)top + this.scrollY;
            for (class_364 widget : this.scrollableWidgets) {
                if (!widget.method_25405(mouseX, adjustedMouseY) || !widget.method_25401(mouseX, adjustedMouseY, horizontalAmount, verticalAmount)) continue;
                return true;
            }
        }
        if (mouseY >= (double)top && mouseY < (double)bottom) {
            this.scrollY -= verticalAmount * 10.0;
            this.clampScroll();
            return true;
        }
        return false;
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        for (class_364 child : this.method_25396()) {
            if (this.scrollableWidgets.contains(child) || !child.method_25402(click, doubled)) continue;
            this.method_25395(child);
            if (button == 0) {
                this.method_25398(true);
            }
            return true;
        }
        int top = this.getTopMargin();
        int bottom = this.field_22790 - this.getBottomMargin();
        int scrollbarX = this.field_22789 - 6 - 2;
        if (mouseX >= (double)scrollbarX && mouseX < (double)this.field_22789 && mouseY >= (double)top && mouseY < (double)bottom) {
            this.isDraggingScrollbar = true;
            return true;
        }
        if (mouseY >= (double)top && mouseY < (double)bottom) {
            double adjustedMouseY = mouseY - (double)top + this.scrollY;
            class_11909 adjustedClick = new class_11909(mouseX, adjustedMouseY, click.comp_4800());
            for (class_364 widget : this.scrollableWidgets) {
                if (!widget.method_25402(adjustedClick, doubled)) continue;
                this.method_25395(widget);
                if (button == 0) {
                    this.method_25398(true);
                }
                return true;
            }
        }
        return false;
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (this.method_25399() != null && this.method_25397() && button == 0) {
            if (this.scrollableWidgets.contains(this.method_25399())) {
                double adjustedMouseY = mouseY - (double)this.getTopMargin() + this.scrollY;
                class_11909 adjustedClick = new class_11909(mouseX, adjustedMouseY, click.comp_4800());
                return this.method_25399().method_25403(adjustedClick, offsetX, offsetY);
            }
            return this.method_25399().method_25403(click, offsetX, offsetY);
        }
        if (this.isDraggingScrollbar) {
            int trackHeight = this.field_22790 - this.getTopMargin() - this.getBottomMargin();
            if (trackHeight <= 0) {
                return true;
            }
            float thumbHeight = Math.max(20.0f, (float)trackHeight / (float)this.totalContentHeight * (float)trackHeight);
            if ((float)trackHeight - thumbHeight <= 0.0f) {
                return true;
            }
            double scrollRatio = (double)this.getMaxScroll() / (double)((float)trackHeight - thumbHeight);
            this.scrollY += offsetY * scrollRatio;
            this.clampScroll();
            return true;
        }
        return false;
    }

    public boolean method_25406(class_11909 click) {
        if (this.isDraggingScrollbar) {
            this.isDraggingScrollbar = false;
            return true;
        }
        if (this.method_25399() != null) {
            boolean handled;
            if (this.scrollableWidgets.contains(this.method_25399())) {
                double adjustedMouseY = click.comp_4799() - (double)this.getTopMargin() + this.scrollY;
                class_11909 adjustedClick = new class_11909(click.comp_4798(), adjustedMouseY, click.comp_4800());
                handled = this.method_25399().method_25406(adjustedClick);
            } else {
                handled = this.method_25399().method_25406(click);
            }
            this.method_25398(false);
            if (handled) {
                return true;
            }
        }
        return super.method_25406(click);
    }

    public boolean method_25404(class_11908 input) {
        if (this.method_25399() != null && this.method_25399().method_25404(input)) {
            return true;
        }
        if (input.method_74234()) {
            this.scrollY -= 10.0;
            this.clampScroll();
            return true;
        }
        if (input.method_74235()) {
            this.scrollY += 10.0;
            this.clampScroll();
            return true;
        }
        return super.method_25404(input);
    }

    private void clampScroll() {
        int maxScroll;
        if (this.scrollY < 0.0) {
            this.scrollY = 0.0;
        }
        if (this.scrollY > (double)(maxScroll = this.getMaxScroll())) {
            this.scrollY = maxScroll;
        }
    }
}

