/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.GameProfile;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import net.atif.buildnotes.Buildnotes;
import net.atif.buildnotes.server.PermissionEntry;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class PermissionManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String PERMISSIONS_FILE = "buildnotes_permissions.json";
    private final Path configPath;
    private final MinecraftServer server;
    private boolean allowAll = false;
    private final Set<PermissionEntry> allowedPlayers = new HashSet<PermissionEntry>();

    public PermissionManager(MinecraftServer server) {
        this.server = server;
        this.configPath = server.method_27050(class_5218.field_24188).resolve("buildnotes").resolve(PERMISSIONS_FILE);
        this.load();
    }

    private void load() {
        try {
            if (Files.notExists(this.configPath, new LinkOption[0])) {
                this.save();
                return;
            }
            try (FileReader reader = new FileReader(this.configPath.toFile());){
                Set loadedEntries;
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (!element.isJsonObject()) {
                    return;
                }
                JsonObject json = element.getAsJsonObject();
                boolean bl = this.allowAll = json.has("allowAll") && json.get("allowAll").getAsBoolean();
                if (json.has("allowedPlayers") && (loadedEntries = (Set)GSON.fromJson(json.get("allowedPlayers"), new TypeToken<HashSet<PermissionEntry>>(){}.getType())) != null) {
                    this.allowedPlayers.addAll(loadedEntries);
                }
            }
        }
        catch (Exception e) {
            Buildnotes.LOGGER.error("Failed to load BuildNotes permissions file!", (Throwable)e);
        }
    }

    private void save() {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(this.configPath.toFile());){
                JsonObject json = new JsonObject();
                json.addProperty("allowAll", Boolean.valueOf(this.allowAll));
                json.add("allowedPlayers", GSON.toJsonTree(this.allowedPlayers));
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Buildnotes.LOGGER.error("Failed to save BuildNotes permissions file!", (Throwable)e);
        }
    }

    public boolean isAllowedToEdit(class_3222 player) {
        if (this.allowAll) {
            return true;
        }
        if (this.server.method_3760().method_14569(player.method_72498())) {
            return true;
        }
        return this.allowedPlayers.stream().anyMatch(entry -> entry.getUuid().equals(player.method_5667()));
    }

    public boolean addPlayer(GameProfile profile) {
        PermissionEntry newEntry = new PermissionEntry(profile.id(), profile.name());
        if (this.allowedPlayers.add(newEntry)) {
            this.save();
            return true;
        }
        return false;
    }

    public boolean removePlayer(GameProfile profile) {
        if (this.allowedPlayers.remove(new PermissionEntry(profile.id(), ""))) {
            this.save();
            return true;
        }
        return false;
    }

    public void setAllowAll(boolean allow) {
        this.allowAll = allow;
        this.save();
    }

    public boolean getAllowAll() {
        return this.allowAll;
    }

    public Set<PermissionEntry> getAllowedPlayers() {
        return new HashSet<PermissionEntry>(this.allowedPlayers);
    }
}

