package net.atif.buildnotes.gui.widget.list;

import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.minecraft.class_1109;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_6382;

public abstract class AbstractListWidget<E extends AbstractListWidget.Entry<E>> extends class_350<E> {

    protected final MainScreen parentScreen;
    private boolean field_22764 = false;
    private static final int FADE_HEIGHT = 12;

    // double-click tracking
    private long lastClickTime = 0L;
    private E lastClickedEntry = null;
    private static final long DOUBLE_CLICK_MS = 250L;

    private boolean isDraggingScrollbar = false;
    private static final int field_55258 = 6;
    private double scrollbarDragStartMouseY;

    public AbstractListWidget(MainScreen parent, class_310 client, int top, int bottom, int itemHeight) {
        // We pass the parent's width and height to the super constructor.
        super(client, parent.field_22789, bottom - top, top, itemHeight);

        this.parentScreen = parent;
    }

    // --- SHARED VISIBILITY LOGIC ---
    public void setVisible(boolean visible) {
        this.field_22764 = visible;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.field_22764) return false;

        if (this.method_25405(mouseX, mouseY) && mouseX >= this.method_65507() && mouseX < this.method_65507() + field_55258) {
            this.isDraggingScrollbar = true;
            this.scrollbarDragStartMouseY = mouseY;
            return true;
        }
        this.isDraggingScrollbar = false;
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        isDraggingScrollbar = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar) {
            int trackHeight = this.method_25364();
            float maxScroll = this.method_44390();
            float thumbHeight = Math.max(10, (float)(trackHeight * trackHeight) / (float)this.method_44395());
            float draggableHeight = trackHeight - thumbHeight;

            if (draggableHeight <= 0) return true; // Cannot drag if thumb fills the track

            // Calculate the ratio of scrollable content to draggable area
            float ratio = maxScroll / draggableHeight;

            // Update scroll amount based on mouse movement since the drag started
            double relativeMouseY = mouseY - this.scrollbarDragStartMouseY;
            this.method_44382(this.method_44387() + (relativeMouseY * ratio));

            // Update the start position for the next frame's calculation
            this.scrollbarDragStartMouseY = mouseY;

            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && super.method_25405(mouseX, mouseY);
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22764) return;

        context.method_44379(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443());

        super.method_48579(context, mouseX, mouseY, delta);
        renderCustomScrollbar(context);

        context.method_44380();

        // Top fade overlay
        int left = this.method_46426();
        int right = this.method_55442();

        int topY = this.method_46427();

        context.method_25296(left, topY, right, topY + FADE_HEIGHT,
                Colors.FADE_GRADIENT_TOP, Colors.FADE_GRADIENT_BOTTOM);

        int bottomY = this.method_55443() - FADE_HEIGHT;
        context.method_25296(left, bottomY, right, this.method_55443(),
                Colors.FADE_GRADIENT_BOTTOM, Colors.FADE_GRADIENT_TOP);

    }

    @Override
    protected void method_57715(class_332 context) {
    }

    @Override
    protected void method_57713(class_332 context) {
    }

    protected void renderCustomScrollbar(class_332 context) {
        int maxScroll = this.method_44390();
        if (maxScroll <= 0) return; // Don't render if not scrollable

        int scrollbarX = this.method_65507();
        int trackHeight = this.method_25364();

        float thumbHeight = Math.max(10, (float)(trackHeight * trackHeight) / (float)this.method_44395());

        float maxThumbY = trackHeight - thumbHeight;

        float thumbY = (float)this.method_44387() / (float)maxScroll * maxThumbY;

        thumbY = Math.min(thumbY, maxThumbY);

        int thumbColor = isDraggingScrollbar ? Colors.SCROLLBAR_THUMB_ACTIVE : Colors.SCROLLBAR_THUMB_INACTIVE;

        context.method_25294(scrollbarX, this.method_46427() + (int) thumbY, scrollbarX + field_55258, this.method_46427() + (int) (thumbY + thumbHeight), thumbColor);
    }

    // --- SHARED LAYOUT METHODS ---
    @Override
    public int method_25322() {
        // Make the list entries 3/5 of the screen's width.
        return (int) (this.parentScreen.field_22789 * 0.6);
    }

    @Override
    protected int method_65507() {
        int listWidth = method_25322();
        int xStart = (this.field_22758 - listWidth) / 2; // center the list
        return xStart + listWidth + 4; // small padding from edge
    }


    // --- SHARED UTILITY OVERRIDES ---
    @Override
    public void method_47399(class_6382 builder) {
        // We don't need narrations for this UI.
    }

    protected void handleEntryClick(E entry) {
        long now = System.currentTimeMillis();
        if (entry == this.lastClickedEntry && (now - this.lastClickTime) <= DOUBLE_CLICK_MS) {
            class_310.method_1551().method_1483().method_4873(
                    class_1109.method_47978(class_3417.field_15015, 1.0F)
            );

            // double click detected
            if (this.parentScreen != null) {
                this.parentScreen.openSelected();
            }
            // reset to avoid triple click detection
            this.lastClickedEntry = null;
            this.lastClickTime = 0L;
            return;
        }
        // not a double click, register this as the last click
        this.lastClickedEntry = entry;
        this.lastClickTime = now;
    }

    public static abstract class Entry<E extends Entry<E>> extends class_350.class_351<E> {
    }

}