package net.atif.buildnotes.gui.widget.list;

import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import java.util.List;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class NoteListWidget extends AbstractListWidget<NoteListWidget.NoteEntry> {

    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");

    public NoteListWidget(MainScreen parent, class_310 client, int top, int bottom, int itemHeight) {
        super(parent, client, top, bottom, itemHeight);
    }

    public void setNotes(List<Note> notes) {
        this.method_25339();
        notes.forEach(note -> this.method_25321(new NoteEntry(note)));
    }

    public Note getSelectedNote() {
        NoteEntry entry = method_25334();
        return entry != null ? entry.getNote() : null;
    }

    @Override
    public void setSelected(NoteEntry entry) {
        super.method_25313(entry);
        parentScreen.onNoteSelected(); // Notify the parent screen
    }

    public class NoteEntry extends AbstractListWidget.Entry<NoteEntry> {
        private final Note note;
        private final String firstLine;
        private final String formattedDateTime;

        public NoteEntry(Note note) {
            this.note = note;
            String content = note.getContent();
            // Check if the content is null or just an empty string
            if (content == null) {
                this.firstLine = "";
            } else {
                // Split the content into lines.
                String[] lines = content.split("\n");
                // THE CRUCIAL CHECK: Make sure the resulting array is not empty.
                if (lines.length > 0) {
                    this.firstLine = lines[0];
                } else {
                    // This handles cases like "" or "\n\n" which result in an empty array.
                    this.firstLine = "";
                }
            }

            LocalDateTime dateTime = LocalDateTime.ofInstant(
                    Instant.ofEpochSecond(note.getLastModified()), ZoneId.systemDefault()
            );

            this.formattedDateTime = dateTime.format(DATE_TIME_FORMATTER);
        }

        public Note getNote() {
            return this.note;
        }


        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            // Prepare Scope indicator to calculate its width
            class_2561 scopeText = null;
            int scopeWidth = 0;
            if (note.getScope() != null) {
                switch (note.getScope()) {
                    case GLOBAL -> scopeText = class_2561.method_43470("Global").method_27692(class_124.field_1075);
                    case SERVER -> scopeText = class_2561.method_43470("Server").method_27692(class_124.field_1060);
                    // We don't draw an indicator for WORLD scope to keep the UI clean
                }
            }

            if (scopeText != null) {
                scopeWidth = field_22740.field_1772.method_27525(scopeText);
            }

            // Truncate and draw the Title
            // Calculate available width for the title by subtracting space for the scope indicator and padding
            int availableTitleWidth = entryWidth - 4; // Base padding
            if (scopeText != null) {
                availableTitleWidth -= (scopeWidth + 7); // Account for the scope text and its padding
            }

            String truncatedTitle = field_22740.field_1772.method_27523(note.getTitle(), availableTitleWidth);
            context.method_51433(field_22740.field_1772, truncatedTitle, x + 2, y + 2, Colors.TEXT_PRIMARY, false);

            if (scopeText != null) {
                context.method_51439(field_22740.field_1772, scopeText, x + entryWidth - scopeWidth - 4, y + 2, Colors.TEXT_PRIMARY, false);
            }

            // Truncate and draw the Content Preview
            class_2561 contentPreview = class_2561.method_43470(firstLine).method_27692(class_124.field_1080);
            String truncatedContent = field_22740.field_1772.method_27523(contentPreview.getString(), entryWidth - 6);
            context.method_51439(field_22740.field_1772, class_2561.method_43470(truncatedContent), x + 2, y + 12, Colors.TEXT_MUTED, false);

            context.method_51433(field_22740.field_1772, "Last Modified: " + this.formattedDateTime, x + 2, y + 22, Colors.TEXT_MUTED, false);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                NoteListWidget.this.setSelected(this);

                NoteListWidget.this.handleEntryClick(this);
                return true;
            }
            return false;
        }
    }
}