package net.atif.buildnotes.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2540;

public class Build extends BaseEntry {
    private String name;
    private String coordinates;
    private String dimension;
    private String description;
    private String credits;
    private final List<CustomField> customFields;
    private List<String> imageFileNames;

    public Build(String name, String coordinates, String dimension, String description, String credits) {
        super();
        this.name = name;
        this.coordinates = coordinates;
        this.dimension = dimension;
        this.description = description;
        this.credits = credits;
        this.customFields = new ArrayList<>();
        this.imageFileNames = new ArrayList<>();
    }

    private Build(UUID id, long lastModified, Scope scope, String name, String coords, String dim, String desc, String cred, List<String> images, List<CustomField> fields) {
        super(id, lastModified, scope);
        this.name = name;
        this.coordinates = coords;
        this.dimension = dim;
        this.description = desc;
        this.credits = cred;
        this.imageFileNames = images;
        this.customFields = fields;
    }

    // --- Getters ---
    public UUID getId() { return super.getId(); } // kept for symmetry with old code (optional)
    public String getName() { return name; }
    public String getCoordinates() { return coordinates; }
    public String getDimension() { return dimension; }
    public String getDescription() { return description; }
    public String getCredits() { return credits; }
    public List<CustomField> getCustomFields() { return customFields; }

    public List<String> getImageFileNames() {
        if (this.imageFileNames == null) {
            // Backward-compatibility for older JSON where this may be null
            this.imageFileNames = new ArrayList<>();
        }
        return this.imageFileNames;
    }

    public long getLastModified() { return super.getLastModified(); }

    // --- Setters ---
    public void setName(String name) { this.name = name; }
    public void setCoordinates(String coordinates) { this.coordinates = coordinates; }
    public void setDimension(String dimension) { this.dimension = dimension; }
    public void setDescription(String description) { this.description = description; }
    public void setCredits(String credits) { this.credits = credits; }

    public void writeToBuf(class_2540 buf) {
        buf.method_10797(this.getId());
        buf.writeLong(this.getLastModified());
        buf.method_10817(this.getScope());
        buf.method_10814(this.name);
        buf.method_10814(this.coordinates);
        buf.method_10814(this.dimension);
        buf.method_10814(this.description);
        buf.method_10814(this.credits);
        buf.method_34062(this.imageFileNames, class_2540::method_10814);
        buf.method_34062(this.customFields, (b, field) -> field.writeToBuf(b));
    }

    public static Build fromBuf(class_2540 buf) {
        UUID id = buf.method_10790();
        long lastModified = buf.readLong();
        Scope scope = buf.method_10818(Scope.class);
        String name = buf.method_19772();
        String coords = buf.method_19772();
        String dim = buf.method_19772();
        String desc = buf.method_19772();
        String cred = buf.method_19772();
        List<String> images = buf.method_34066(class_2540::method_19772);
        List<CustomField> fields = buf.method_34066(CustomField::fromBuf);

        return new Build(id, lastModified, scope, name, coords, dim, desc, cred, images, fields);
    }
}
