package net.atif.buildnotes.gui.screen;

import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ConfirmScreen extends BaseScreen {

    private final class_2561 message;
    private final Runnable onConfirm;
    private final Runnable onCancel;

    public ConfirmScreen(class_437 parent, class_2561 message, Runnable onConfirm, Runnable onCancel) {
        super(class_2561.method_30163("Confirm"), parent);
        this.message = message;
        this.onConfirm = onConfirm;
        this.onCancel = onCancel;
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        int panelW = Math.min(this.field_22789 - 80, 360);
        int panelH = 100;
        int panelX = (this.field_22789 - panelW) / 2;
        int panelY = (this.field_22790 - panelH) / 2;

        int btnY = panelY + panelH - UIHelper.BUTTON_HEIGHT - UIHelper.BOTTOM_PADDING;

        UIHelper.createBottomButtonRow(this, btnY, 2, x -> {
            boolean isLeft = x == UIHelper.getCenteredButtonStartX(this.field_22789, 2);
            this.method_37063(new DarkButtonWidget(
                    x, btnY, UIHelper.BUTTON_WIDTH, UIHelper.BUTTON_HEIGHT,
                    class_2561.method_30163(isLeft ? "Yes" : "No"),
                    b -> { if (isLeft) onConfirm.run(); else onCancel.run(); }
            ));
        });
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);

        int panelW = Math.min(this.field_22789 - 80, 360);
        int panelH = 100;
        int panelX = (this.field_22789 - panelW) / 2;
        int panelY = (this.field_22790 - panelH) / 2;

        UIHelper.drawPanel(matrices, panelX, panelY, panelW, panelH);

        this.field_22793.method_1712(this.message, panelX + 12, panelY + 12, panelW - 24, 0xFFFFFF);

        super.method_25394(matrices, mouseX, mouseY, delta);
    }
}
