/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.network;

import java.util.List;
import java.util.UUID;
import net.atif.buildnotes.client.ClientCache;
import net.atif.buildnotes.client.ClientImageTransferManager;
import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.data.PermissionLevel;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.atif.buildnotes.network.packet.c2s.RequestDataC2SPacket;
import net.atif.buildnotes.network.packet.s2c.DeleteBuildS2CPacket;
import net.atif.buildnotes.network.packet.s2c.DeleteNoteS2CPacket;
import net.atif.buildnotes.network.packet.s2c.HandshakeS2CPacket;
import net.atif.buildnotes.network.packet.s2c.ImageChunkS2CPacket;
import net.atif.buildnotes.network.packet.s2c.ImageNotFoundS2CPacket;
import net.atif.buildnotes.network.packet.s2c.InitialSyncS2CPacket;
import net.atif.buildnotes.network.packet.s2c.UpdateBuildS2CPacket;
import net.atif.buildnotes.network.packet.s2c.UpdateNoteS2CPacket;
import net.atif.buildnotes.network.packet.s2c.UpdatePermissionS2CPacket;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_8710;

public class ClientPacketHandler {
    private static void refreshMainScreen(class_310 client) {
        if (client.field_1755 instanceof MainScreen) {
            ((MainScreen)client.field_1755).refreshData();
        }
    }

    public static void handleHandshake(class_310 client, HandshakeS2CPacket packet) {
        PermissionLevel permission = packet.permission();
        ClientSession.joinServer(permission);
        ClientPlayNetworking.send((class_8710)new RequestDataC2SPacket());
    }

    public static void handleUpdatePermission(class_310 client, UpdatePermissionS2CPacket packet) {
        PermissionLevel newLevel = packet.permission();
        ClientSession.updatePermissionLevel(newLevel);
        ClientPacketHandler.refreshMainScreen(client);
    }

    public static void handleInitialSync(class_310 client, InitialSyncS2CPacket packet) {
        List<Note> notes = packet.notes();
        List<Build> builds = packet.builds();
        ClientCache.setNotes(notes);
        ClientCache.setBuilds(builds);
        ClientPacketHandler.refreshMainScreen(client);
    }

    public static void handleUpdateNote(class_310 client, UpdateNoteS2CPacket packet) {
        Note updatedNote = packet.note();
        ClientCache.addOrUpdateNote(updatedNote);
        ClientPacketHandler.refreshMainScreen(client);
    }

    public static void handleUpdateBuild(class_310 client, UpdateBuildS2CPacket packet) {
        Build updatedBuild = packet.build();
        ClientCache.addOrUpdateBuild(updatedBuild);
        ClientPacketHandler.refreshMainScreen(client);
    }

    public static void handleDeleteNote(class_310 client, DeleteNoteS2CPacket packet) {
        UUID noteId = packet.noteId();
        ClientCache.removeNoteById(noteId);
        ClientPacketHandler.refreshMainScreen(client);
    }

    public static void handleDeleteBuild(class_310 client, DeleteBuildS2CPacket packet) {
        UUID buildId = packet.buildId();
        ClientCache.removeBuildById(buildId);
        ClientPacketHandler.refreshMainScreen(client);
    }

    public static void handleImageChunk(class_310 client, ImageChunkS2CPacket packet) {
        ClientImageTransferManager.handleChunk(packet.buildId(), packet.filename(), packet.totalChunks(), packet.chunkIndex(), packet.data());
    }

    public static void handleImageNotFound(class_310 client, ImageNotFoundS2CPacket packet) {
        ClientImageTransferManager.onDownloadFailed(packet.buildId(), packet.filename());
    }
}

