/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.atif.buildnotes.Buildnotes;
import net.atif.buildnotes.client.ClientCache;
import net.atif.buildnotes.client.ClientImageTransferManager;
import net.atif.buildnotes.data.BaseEntry;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.data.Scope;
import net.atif.buildnotes.network.PacketIdentifiers;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5218;

public class DataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final String NOTES_FILE_NAME = "notes.json";
    private static final String BUILDS_FILE_NAME = "builds.json";
    private static final String MOD_DATA_SUBFOLDER = "buildnotes";
    private static final String PER_SERVER_SUBFOLDER = "servers";
    private static DataManager instance;

    private DataManager() {
    }

    public static DataManager getInstance() {
        if (instance == null) {
            instance = new DataManager();
        }
        return instance;
    }

    private Path getGlobalPath() {
        return CONFIG_DIR.resolve(MOD_DATA_SUBFOLDER);
    }

    private Path getSinglePlayerWorldPath() {
        class_310 client = class_310.method_1551();
        if (client.method_1496() && client.method_1576() != null) {
            return client.method_1576().method_27050(class_5218.field_24188).resolve(MOD_DATA_SUBFOLDER);
        }
        return null;
    }

    private Path getPerServerPath() {
        class_310 client = class_310.method_1551();
        if (client.method_1558() != null) {
            String serverAddress = client.method_1558().field_3761;
            String sanitizedAddress = serverAddress.replace(":", "_").replaceAll("[^a-zA-Z0-9_.-]", "_");
            return this.getGlobalPath().resolve(PER_SERVER_SUBFOLDER).resolve(sanitizedAddress);
        }
        return null;
    }

    private Path getLocalPath() {
        Path spPath = this.getSinglePlayerWorldPath();
        return spPath != null ? spPath : this.getPerServerPath();
    }

    private Path getLocalImagePath(UUID buildId) {
        return FabricLoader.getInstance().getConfigDir().resolve(MOD_DATA_SUBFOLDER).resolve("images").resolve(buildId.toString());
    }

    private <T> List<T> loadFromFile(Path path, String fileName, Type type) {
        List list;
        if (path == null) {
            return new ArrayList();
        }
        File file = path.resolve(fileName).toFile();
        if (!file.exists()) {
            return new ArrayList();
        }
        FileReader reader = new FileReader(file);
        try {
            List loadedData = (List)GSON.fromJson((Reader)reader, type);
            list = loadedData != null ? loadedData : new ArrayList();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Buildnotes.LOGGER.warn("Could not load from {}, creating new list...", (Object)file.getAbsolutePath(), (Object)e);
                return new ArrayList();
            }
        }
        reader.close();
        return list;
    }

    private <T> void writeToFile(List<T> data, Path path, String fileName) {
        if (path == null) {
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(path.resolve(fileName).toFile());){
                GSON.toJson(data, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Buildnotes.LOGGER.error("Could not save to {}", (Object)path.resolve(fileName), (Object)e);
        }
    }

    private void deleteNoteFromLocalFiles(UUID id) {
        Path localPath;
        List localNotes;
        Path globalPath = this.getGlobalPath();
        List globalNotes = this.loadFromFile(globalPath, NOTES_FILE_NAME, new TypeToken<ArrayList<Note>>(){}.getType());
        if (globalNotes.removeIf(n -> n.getId().equals(id))) {
            this.writeToFile(globalNotes, globalPath, NOTES_FILE_NAME);
        }
        if ((localNotes = this.loadFromFile(localPath = this.getLocalPath(), NOTES_FILE_NAME, new TypeToken<ArrayList<Note>>(){}.getType())).removeIf(n -> n.getId().equals(id))) {
            this.writeToFile(localNotes, localPath, NOTES_FILE_NAME);
        }
    }

    private void deleteBuildFromLocalFiles(UUID id) {
        Path localPath;
        List localBuilds;
        Path globalPath = this.getGlobalPath();
        List globalBuilds = this.loadFromFile(globalPath, BUILDS_FILE_NAME, new TypeToken<ArrayList<Build>>(){}.getType());
        if (globalBuilds.removeIf(b -> b.getId().equals(id))) {
            this.writeToFile(globalBuilds, globalPath, BUILDS_FILE_NAME);
        }
        if ((localBuilds = this.loadFromFile(localPath = this.getLocalPath(), BUILDS_FILE_NAME, new TypeToken<ArrayList<Build>>(){}.getType())).removeIf(b -> b.getId().equals(id))) {
            this.writeToFile(localBuilds, localPath, BUILDS_FILE_NAME);
        }
    }

    public List<Note> getNotes() {
        List globalNotes = this.loadFromFile(this.getGlobalPath(), NOTES_FILE_NAME, new TypeToken<ArrayList<Note>>(){}.getType());
        List localNotes = this.loadFromFile(this.getLocalPath(), NOTES_FILE_NAME, new TypeToken<ArrayList<Note>>(){}.getType());
        List<Note> serverNotes = ClientCache.getNotes();
        return Stream.of(globalNotes, localNotes, serverNotes).flatMap(Collection::stream).sorted(Comparator.comparingLong(BaseEntry::getLastModified).reversed()).collect(Collectors.toList());
    }

    public void saveNote(Note noteToSave) {
        if (noteToSave.getScope() == Scope.SERVER) {
            this.deleteNoteFromLocalFiles(noteToSave.getId());
            class_2540 buf = new class_2540(Unpooled.buffer());
            noteToSave.writeToBuf(buf);
            ClientPlayNetworking.send((class_2960)PacketIdentifiers.SAVE_NOTE_C2S, (class_2540)buf);
            return;
        }
        UUID noteId = noteToSave.getId();
        boolean wasServerNote = ClientCache.getNotes().stream().anyMatch(n -> n.getId().equals(noteId));
        if (wasServerNote) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(noteId);
            ClientPlayNetworking.send((class_2960)PacketIdentifiers.DELETE_NOTE_C2S, (class_2540)buf);
        }
        this.deleteNoteFromLocalFiles(noteId);
        Path path = noteToSave.getScope() == Scope.GLOBAL ? this.getGlobalPath() : this.getLocalPath();
        Type type = new TypeToken<ArrayList<Note>>(){}.getType();
        List notes = this.loadFromFile(path, NOTES_FILE_NAME, type);
        notes.add(noteToSave);
        this.writeToFile(notes, path, NOTES_FILE_NAME);
    }

    public void deleteNote(Note noteToDelete) {
        if (noteToDelete.getScope() == Scope.SERVER) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(noteToDelete.getId());
            ClientPlayNetworking.send((class_2960)PacketIdentifiers.DELETE_NOTE_C2S, (class_2540)buf);
            return;
        }
        this.deleteNoteFromLocalFiles(noteToDelete.getId());
    }

    public List<Build> getBuilds() {
        List globalBuilds = this.loadFromFile(this.getGlobalPath(), BUILDS_FILE_NAME, new TypeToken<ArrayList<Build>>(){}.getType());
        List localBuilds = this.loadFromFile(this.getLocalPath(), BUILDS_FILE_NAME, new TypeToken<ArrayList<Build>>(){}.getType());
        List<Build> serverBuilds = ClientCache.getBuilds();
        return Stream.of(globalBuilds, localBuilds, serverBuilds).flatMap(Collection::stream).sorted(Comparator.comparingLong(Build::getLastModified).reversed()).collect(Collectors.toList());
    }

    public void saveBuild(Build buildToSave) {
        if (buildToSave.getScope() == Scope.SERVER) {
            this.deleteBuildFromLocalFiles(buildToSave.getId());
            ArrayList<Path> imagesToUpload = new ArrayList<Path>();
            Path imageDir = this.getLocalImagePath(buildToSave.getId());
            for (String filename : buildToSave.getImageFileNames()) {
                Path localPath = imageDir.resolve(filename);
                if (!Files.exists(localPath, new LinkOption[0])) continue;
                imagesToUpload.add(localPath);
            }
            if (!imagesToUpload.isEmpty()) {
                ClientImageTransferManager.scheduleUploads(buildToSave.getId(), imagesToUpload);
            }
            class_2540 buf = new class_2540(Unpooled.buffer());
            buildToSave.writeToBuf(buf);
            ClientPlayNetworking.send((class_2960)PacketIdentifiers.SAVE_BUILD_C2S, (class_2540)buf);
            return;
        }
        UUID buildId = buildToSave.getId();
        boolean wasServerBuild = ClientCache.getBuilds().stream().anyMatch(b -> b.getId().equals(buildId));
        if (wasServerBuild) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(buildId);
            ClientPlayNetworking.send((class_2960)PacketIdentifiers.DELETE_BUILD_C2S, (class_2540)buf);
        }
        this.deleteBuildFromLocalFiles(buildId);
        Path path = buildToSave.getScope() == Scope.GLOBAL ? this.getGlobalPath() : this.getLocalPath();
        Type type = new TypeToken<ArrayList<Build>>(){}.getType();
        List builds = this.loadFromFile(path, BUILDS_FILE_NAME, type);
        builds.add(buildToSave);
        this.writeToFile(builds, path, BUILDS_FILE_NAME);
    }

    public void deleteBuild(Build buildToDelete) {
        block9: {
            if (buildToDelete.getScope() == Scope.SERVER) {
                class_2540 buf = new class_2540(Unpooled.buffer());
                buf.method_10797(buildToDelete.getId());
                ClientPlayNetworking.send((class_2960)PacketIdentifiers.DELETE_BUILD_C2S, (class_2540)buf);
                return;
            }
            this.deleteBuildFromLocalFiles(buildToDelete.getId());
            try {
                Path imageDir = CONFIG_DIR.resolve(MOD_DATA_SUBFOLDER).resolve("images").resolve(buildToDelete.getId().toString());
                if (!Files.exists(imageDir, new LinkOption[0])) break block9;
                try (Stream<Path> walk = Files.walk(imageDir, new FileVisitOption[0]);){
                    walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
            }
            catch (IOException e) {
                Buildnotes.LOGGER.error("Failed to delete image directory for build: {}", (Object)buildToDelete.getId(), (Object)e);
            }
        }
    }
}

