/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.network;

import java.util.List;
import java.util.UUID;
import net.atif.buildnotes.client.ClientCache;
import net.atif.buildnotes.client.ClientImageTransferManager;
import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.data.PermissionLevel;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class ClientPacketHandler {
    private static void refreshMainScreen(class_310 client) {
        if (client.field_1755 instanceof MainScreen) {
            ((MainScreen)client.field_1755).refreshData();
        }
    }

    public static void handleInitialSync(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        List notes = buf.method_34066(Note::fromBuf);
        List builds = buf.method_34066(Build::fromBuf);
        client.execute(() -> {
            ClientCache.setNotes(notes);
            ClientCache.setBuilds(builds);
            ClientPacketHandler.refreshMainScreen(client);
        });
    }

    public static void handleUpdatePermission(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        PermissionLevel newLevel = (PermissionLevel)buf.method_10818(PermissionLevel.class);
        client.execute(() -> {
            ClientSession.updatePermissionLevel(newLevel);
            ClientPacketHandler.refreshMainScreen(client);
        });
    }

    public static void handleUpdateNote(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        Note updatedNote = Note.fromBuf(buf);
        client.execute(() -> {
            ClientCache.addOrUpdateNote(updatedNote);
            ClientPacketHandler.refreshMainScreen(client);
        });
    }

    public static void handleUpdateBuild(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        Build updatedBuild = Build.fromBuf(buf);
        client.execute(() -> {
            ClientCache.addOrUpdateBuild(updatedBuild);
            ClientPacketHandler.refreshMainScreen(client);
        });
    }

    public static void handleDeleteNote(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        UUID noteId = buf.method_10790();
        client.execute(() -> {
            ClientCache.removeNoteById(noteId);
            ClientPacketHandler.refreshMainScreen(client);
        });
    }

    public static void handleDeleteBuild(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        UUID buildId = buf.method_10790();
        client.execute(() -> {
            ClientCache.removeBuildById(buildId);
            ClientPacketHandler.refreshMainScreen(client);
        });
    }

    public static void handleImageChunk(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        UUID buildId = buf.method_10790();
        String filename = buf.method_19772();
        int totalChunks = buf.method_10816();
        int chunkIndex = buf.method_10816();
        byte[] data = buf.method_10795();
        client.execute(() -> ClientImageTransferManager.handleChunk(buildId, filename, totalChunks, chunkIndex, data));
    }

    public static void handleImageNotFound(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        UUID buildId = buf.method_10790();
        String filename = buf.method_19772();
        client.execute(() -> ClientImageTransferManager.onDownloadFailed(buildId, filename));
    }
}

