package net.atif.buildnotes.client;

import io.netty.buffer.Unpooled;
import net.atif.buildnotes.data.PermissionLevel;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.atif.buildnotes.data.TabType;
import net.atif.buildnotes.network.ClientPacketHandler;
import net.atif.buildnotes.network.PacketIdentifiers;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_634;

@Environment(EnvType.CLIENT)
public class BuildnotesClient implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        KeyBinds.register();

        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (KeyBinds.openGuiKey.method_1436()) {
                if (client.field_1755 == null) {
                    client.method_1507(new MainScreen(TabType.NOTES));
                }
            }
        });

        // ADDED: Register all your S2C packet handlers here
        ClientPlayNetworking.registerGlobalReceiver(PacketIdentifiers.HANDSHAKE_S2C, this::handleHandshake);
        ClientPlayNetworking.registerGlobalReceiver(PacketIdentifiers.INITIAL_SYNC_S2C, ClientPacketHandler::handleInitialSync);
        ClientPlayNetworking.registerGlobalReceiver(PacketIdentifiers.UPDATE_NOTE_S2C, ClientPacketHandler::handleUpdateNote);
        ClientPlayNetworking.registerGlobalReceiver(PacketIdentifiers.UPDATE_BUILD_S2C, ClientPacketHandler::handleUpdateBuild);
        ClientPlayNetworking.registerGlobalReceiver(PacketIdentifiers.DELETE_NOTE_S2C, ClientPacketHandler::handleDeleteNote);
        ClientPlayNetworking.registerGlobalReceiver(PacketIdentifiers.DELETE_BUILD_S2C, ClientPacketHandler::handleDeleteBuild);
        ClientPlayNetworking.registerGlobalReceiver(PacketIdentifiers.IMAGE_CHUNK_S2C, ClientPacketHandler::handleImageChunk);
        ClientPlayNetworking.registerGlobalReceiver(PacketIdentifiers.IMAGE_NOT_FOUND_S2C, ClientPacketHandler::handleImageNotFound);

        // Register disconnect event to clear server-side cache
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            client.execute(() -> {
                ClientSession.leaveServer();
                ClientCache.clear();
            });
        });
    }

    private void handleHandshake(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        PermissionLevel permission = buf.method_10818(PermissionLevel.class);

        // This code runs on the main render thread, so it's safe to update our session
        client.execute(() -> {
            // Set the session state *here* after receiving the handshake
            ClientSession.joinServer(permission);
            // After joining, immediately request data from the server
            ClientPlayNetworking.send(PacketIdentifiers.REQUEST_DATA_C2S, new class_2540(Unpooled.buffer()));
        });
    }
}