package net.atif.buildnotes.gui.screen;

import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.data.Scope;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.MultiLineTextFieldWidget;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import java.util.List;

public class EditNoteScreen extends BaseScreen {

    private final Note note;

    private MultiLineTextFieldWidget titleField;
    private MultiLineTextFieldWidget contentField;
    private DarkButtonWidget scopeToggleButton;

    public EditNoteScreen(class_437 parent, Note note) {
        super(new class_2588("gui.buildnotes.edit_note_title"), parent);
        this.note = note;
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        int contentWidth = (int) (this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int topMargin = 20;
        int titlePanelHeight = 25;
        int panelSpacing = 5;
        int bottomMargin = 70;

        // --- Title Text Field ---
        this.titleField = new MultiLineTextFieldWidget(
                this.field_22793,
                contentX,
                topMargin + 5,
                contentWidth,
                titlePanelHeight,
                note.getTitle(),
                new class_2588("gui.buildnotes.placeholder.title").getString(),
                1, false
        );
        this.method_25429(this.titleField);

        // --- Content Text Field ---
        int contentPanelY = topMargin + titlePanelHeight + panelSpacing;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        this.contentField = new MultiLineTextFieldWidget(
                this.field_22793, contentX, contentPanelY, contentWidth,
                contentPanelBottom - contentPanelY, note.getContent(),
                new class_2588("gui.buildnotes.placeholder.note_content").getString(), Integer.MAX_VALUE, true
        );
        this.method_25429(this.contentField);

        // --- TOP BUTTON ROW (3) ---
        int topRowY = this.field_22790 - (UIHelper.BUTTON_HEIGHT + UIHelper.BOTTOM_PADDING) - UIHelper.BUTTON_HEIGHT - 5;
        List<class_2561> topButtonTexts = List.of(
                new class_2588("gui.buildnotes.edit.coords"),
                new class_2588("gui.buildnotes.edit.biome"),
                getScopeButtonText()
        );

        UIHelper.createBottomButtonRow(this, topRowY, topButtonTexts, (index, x, width) -> { // Note the new 'width' parameter
            switch (index) {
                case 0 -> this.method_37063(new DarkButtonWidget(x, topRowY, width, UIHelper.BUTTON_HEIGHT, topButtonTexts.get(0), b -> insertCoords()));
                case 1 -> this.method_37063(new DarkButtonWidget(x, topRowY, width, UIHelper.BUTTON_HEIGHT, topButtonTexts.get(1), b -> insertBiome()));
                case 2 -> {
                    this.method_37063(new DarkButtonWidget(x, topRowY, width, UIHelper.BUTTON_HEIGHT, topButtonTexts.get(2), b -> {
                        saveNote();
                        cycleScope();
                        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                    }));
                }
            }
        });

        // --- BOTTOM BUTTON ROW ---
        int bottomRowY = this.field_22790 - UIHelper.BUTTON_HEIGHT - UIHelper.BOTTOM_PADDING;
        List<class_2561> bottomButtonTexts = List.of(
                new class_2588("gui.buildnotes.save_button"),
                new class_2588("gui.buildnotes.close_button")
        );
        UIHelper.createBottomButtonRow(this, bottomRowY, bottomButtonTexts, (index, x, width) -> {
            if (index == 0) {
                this.method_37063(new DarkButtonWidget(x, bottomRowY, width, UIHelper.BUTTON_HEIGHT, bottomButtonTexts.get(0), button -> saveNote()));
            } else {
                this.method_37063(new DarkButtonWidget(x, bottomRowY, width, UIHelper.BUTTON_HEIGHT, bottomButtonTexts.get(1), button -> this.method_25419()));
            }
        });

        this.method_20085(this.titleField);
    }

    private void cycleScope() {
        Scope currentScope = note.getScope();
        if (ClientSession.isOnServer() && ClientSession.hasEditPermission()) {
            // Cycle through all three: WORLD -> GLOBAL -> SERVER -> WORLD
            if (currentScope == Scope.WORLD) note.setScope(Scope.GLOBAL);
            else if (currentScope == Scope.GLOBAL) note.setScope(Scope.SERVER);
            else note.setScope(Scope.WORLD);
        } else {
            // Cycle between WORLD and GLOBAL
            note.setScope(currentScope == Scope.WORLD ? Scope.GLOBAL : Scope.WORLD);
        }
    }

    private class_2561 getScopeButtonText() {
        class_2561 scopeName;
        Scope currentScope = note.getScope();
        if (currentScope == Scope.GLOBAL) {
            scopeName = new class_2588("gui.buildnotes.edit.scope.global");
        } else if (currentScope == Scope.SERVER) {
            scopeName = new class_2588("gui.buildnotes.edit.scope.server");
        } else {
            scopeName = this.field_22787 != null && this.field_22787.method_1496()
                    ? new class_2588("gui.buildnotes.edit.scope.world")
                    : new class_2588("gui.buildnotes.edit.scope.per_server");
        }
        return new class_2588("gui.buildnotes.edit.scope_button", scopeName);
    }

    private void saveNote() {
        note.setTitle(this.titleField.getText());
        note.setContent(this.contentField.getText());
        note.updateTimestamp();
        DataManager.getInstance().saveNote(this.note);
    }


    private void insertCoords() {
        if (this.field_22787.field_1724 == null) return;
        String coords = String.format("X: %.0f, Y: %.0f, Z: %.0f", this.field_22787.field_1724.method_23317(), this.field_22787.field_1724.method_23318(), this.field_22787.field_1724.method_23321());
        this.contentField.insertText(coords);
    }

    private void insertBiome() {
        if (this.field_22787.field_1724 == null || this.field_22787.field_1687 == null) return;
        class_2338 playerPos = this.field_22787.field_1724.method_24515();
        String biomeId = this.field_22787.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221(this.field_22787.field_1687.method_23753(playerPos).comp_349()).toString();
        this.contentField.insertText(biomeId);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);

        int contentWidth = (int) (this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int topMargin = 20;
        int titlePanelHeight = 25;
        int panelSpacing = 5;
        int bottomMargin = 70;

        // --- Title Panel ---
        UIHelper.drawPanel(matrices, contentX, topMargin, contentWidth, titlePanelHeight);;
        this.titleField.method_25394(matrices, mouseX, mouseY, delta);

        // --- Content Panel ---
        int contentPanelY = topMargin + titlePanelHeight + panelSpacing;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        UIHelper.drawPanel(matrices, contentX, contentPanelY, contentWidth, contentPanelBottom - contentPanelY);
        this.contentField.method_25394(matrices, mouseX, mouseY, delta);

        // Draw screen title
        method_27534(matrices, this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    // We need to override mouseScrolled to pass the event to our custom widget
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return this.contentField.method_25401(mouseX, mouseY, amount) || super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    public void method_25419() {
        saveNote();
        super.method_25419();
    }
}