package net.atif.buildnotes.network;

import io.netty.buffer.Unpooled;
import net.atif.buildnotes.Buildnotes;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.server.ServerDataManager;
import net.atif.buildnotes.server.ServerImageTransferManager;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import java.util.List;
import java.util.UUID;

public class ServerPacketHandler {

    private static boolean hasEditPermission(MinecraftServer server, class_3222 player) {
        return Buildnotes.PERMISSION_MANAGER.isAllowedToEdit(player);
    }

    public static void handleRequestInitialData(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        server.execute(() -> {
            // Access SERVER_DATA_MANAGER statically from the main mod class
            ServerDataManager dataManager = Buildnotes.SERVER_DATA_MANAGER;
            List<Note> notes = dataManager.getNotes();
            List<Build> builds = dataManager.getBuilds();

            class_2540 responseBuf = new class_2540(Unpooled.buffer());
            responseBuf.method_34062(notes, (b, n) -> n.writeToBuf(b));
            responseBuf.method_34062(builds, (b, B) -> B.writeToBuf(b));

            ServerPlayNetworking.send(player, PacketIdentifiers.INITIAL_SYNC_S2C, responseBuf);
        });
    }

    public static void handleSaveNote(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        Note receivedNote = Note.fromBuf(buf);
        server.execute(() -> {
            if (!hasEditPermission(server, player)) return;

            Buildnotes.SERVER_DATA_MANAGER.saveNote(receivedNote);

            // Broadcast the update to all players
            for (class_3222 p : server.method_3760().method_14571()) {
                class_2540 copy = new class_2540(Unpooled.buffer());
                receivedNote.writeToBuf(copy);
                ServerPlayNetworking.send(p, PacketIdentifiers.UPDATE_NOTE_S2C, copy);
            }
        });
    }

    // Handler for saving a build
    public static void handleSaveBuild(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        Build receivedBuild = Build.fromBuf(buf);
        server.execute(() -> {
            if (!hasEditPermission(server, player)) return;

            Buildnotes.SERVER_DATA_MANAGER.saveBuild(receivedBuild);

            for (class_3222 p : server.method_3760().method_14571()) {
                class_2540 copy = new class_2540(Unpooled.buffer());
                receivedBuild.writeToBuf(copy);
                ServerPlayNetworking.send(p, PacketIdentifiers.UPDATE_BUILD_S2C, copy);
            }
        });
    }

    // Handler for deleting a note
    public static void handleDeleteNote(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        UUID noteId = buf.method_10790();
        server.execute(() -> {
            if (!hasEditPermission(server, player)) return;

            Buildnotes.SERVER_DATA_MANAGER.deleteNote(noteId);

            class_2540 responseBuf = new class_2540(Unpooled.buffer());
            responseBuf.method_10797(noteId);
            for (class_3222 p : server.method_3760().method_14571()) {
                ServerPlayNetworking.send(p, PacketIdentifiers.DELETE_NOTE_S2C, responseBuf);
            }
        });
    }

    // Handler for deleting a build
    public static void handleDeleteBuild(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        UUID buildId = buf.method_10790();
        server.execute(() -> {
            if (!hasEditPermission(server, player)) return;

            Buildnotes.SERVER_DATA_MANAGER.deleteBuild(buildId);

            class_2540 responseBuf = new class_2540(Unpooled.buffer());
            responseBuf.method_10797(buildId);
            for (class_3222 p : server.method_3760().method_14571()) {
                ServerPlayNetworking.send(p, PacketIdentifiers.DELETE_BUILD_S2C, responseBuf);
            }
        });
    }

    public static void handleImageChunkUpload(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        UUID buildId = buf.method_10790();
        String filename = buf.method_19772();
        int totalChunks = buf.method_10816();
        int chunkIndex = buf.method_10816();
        byte[] data = buf.method_10795();

        // Must execute on the server thread to ensure thread safety with the map
        server.execute(() -> ServerImageTransferManager.handleChunk(player, buildId, filename, totalChunks, chunkIndex, data));
    }

    public static void handleImageRequest(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        UUID buildId = buf.method_10790();
        String filename = buf.method_19772();

        server.execute(() -> {
            // This now needs to be implemented: a method to read and send an image from the server
            Buildnotes.SERVER_DATA_MANAGER.sendImageToPlayer(player, buildId, filename);
        });
    }
}