/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.atif.buildnotes.gui.screen.BaseScreen;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;

public abstract class ScrollableScreen
extends BaseScreen {
    protected final List<class_364> scrollableWidgets = Lists.newArrayList();
    protected double scrollY = 0.0;
    protected int totalContentHeight = 0;
    private boolean isDraggingScrollbar = false;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int SCROLLBAR_PADDING = 2;

    protected ScrollableScreen(class_2561 title, class_437 parent) {
        super(title, parent);
    }

    protected abstract void initContent();

    protected abstract void renderContent(class_4587 var1, int var2, int var3, float var4);

    protected abstract int getTopMargin();

    protected abstract int getBottomMargin();

    @Override
    protected void method_25426() {
        super.method_25426();
        this.scrollableWidgets.clear();
        this.scrollY = 0.0;
        this.initContent();
    }

    protected <T extends class_364 & class_6379> T addScrollableWidget(T widget) {
        this.scrollableWidgets.add(widget);
        return (T)this.method_25429(widget);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_4068 drawable;
        this.method_25420(matrices);
        int top = this.getTopMargin();
        int bottom = this.field_22790 - this.getBottomMargin();
        if (bottom <= top) {
            return;
        }
        double scale = this.field_22787.method_22683().method_4495();
        RenderSystem.enableScissor((int)((int)(0.0 * scale)), (int)((int)((double)this.field_22787.method_22683().method_4506() - (double)bottom * scale)), (int)((int)((double)this.field_22789 * scale)), (int)((int)((double)(bottom - top) * scale)));
        matrices.method_22903();
        matrices.method_22904(0.0, (double)top, 0.0);
        matrices.method_22904(0.0, -this.scrollY, 0.0);
        int adjustedMouseY = (int)((double)(mouseY - top) + this.scrollY);
        this.renderContent(matrices, mouseX, adjustedMouseY, delta);
        for (class_364 widget : this.scrollableWidgets) {
            if (!(widget instanceof class_4068)) continue;
            drawable = (class_4068)widget;
            drawable.method_25394(matrices, mouseX, adjustedMouseY, delta);
        }
        matrices.method_22909();
        RenderSystem.disableScissor();
        for (class_364 child : this.method_25396()) {
            if (this.scrollableWidgets.contains(child) || !(child instanceof class_4068)) continue;
            drawable = (class_4068)child;
            drawable.method_25394(matrices, mouseX, mouseY, delta);
        }
        this.renderScrollbar(matrices);
    }

    private void renderScrollbar(class_4587 matrices) {
        int top = this.getTopMargin();
        int bottom = this.field_22790 - this.getBottomMargin();
        int trackHeight = bottom - top;
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int scrollbarX = this.field_22789 - 6 - 2;
            float thumbHeight = Math.max(20.0f, (float)trackHeight / (float)this.totalContentHeight * (float)trackHeight);
            float thumbY = (float)(this.scrollY / (double)maxScroll * (double)((float)trackHeight - thumbHeight));
            int color = this.isDraggingScrollbar ? -1 : -1996488705;
            ScrollableScreen.method_25294((class_4587)matrices, (int)scrollbarX, (int)(top + (int)thumbY), (int)(scrollbarX + 6), (int)(top + (int)(thumbY + thumbHeight)), (int)color);
        }
    }

    private int getMaxScroll() {
        int visibleHeight = this.field_22790 - this.getTopMargin() - this.getBottomMargin();
        return Math.max(0, this.totalContentHeight - visibleHeight);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int top = this.getTopMargin();
        int bottom = this.field_22790 - this.getBottomMargin();
        if (mouseY >= (double)top && mouseY < (double)bottom) {
            double adjustedMouseY = mouseY - (double)top + this.scrollY;
            for (class_364 widget : this.scrollableWidgets) {
                if (!widget.method_25405(mouseX, adjustedMouseY) || !widget.method_25401(mouseX, adjustedMouseY, amount)) continue;
                return true;
            }
        }
        if (mouseY >= (double)top && mouseY < (double)bottom) {
            this.scrollY -= amount * 10.0;
            this.clampScroll();
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_364 child : this.method_25396()) {
            if (this.scrollableWidgets.contains(child) || !child.method_25402(mouseX, mouseY, button)) continue;
            this.method_25395(child);
            if (button == 0) {
                this.method_25398(true);
            }
            return true;
        }
        int top = this.getTopMargin();
        int bottom = this.field_22790 - this.getBottomMargin();
        int scrollbarX = this.field_22789 - 6 - 2;
        if (mouseX >= (double)scrollbarX && mouseX < (double)this.field_22789 && mouseY >= (double)top && mouseY < (double)bottom) {
            this.isDraggingScrollbar = true;
            return true;
        }
        if (mouseY >= (double)top && mouseY < (double)bottom) {
            double adjustedMouseY = mouseY - (double)top + this.scrollY;
            for (class_364 widget : this.scrollableWidgets) {
                if (!widget.method_25402(mouseX, adjustedMouseY, button)) continue;
                this.method_25395(widget);
                if (button == 0) {
                    this.method_25398(true);
                }
                return true;
            }
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.method_25399() != null && this.method_25397() && button == 0) {
            if (this.scrollableWidgets.contains(this.method_25399())) {
                double adjustedMouseY = mouseY - (double)this.getTopMargin() + this.scrollY;
                return this.method_25399().method_25403(mouseX, adjustedMouseY, button, deltaX, deltaY);
            }
            return this.method_25399().method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.isDraggingScrollbar) {
            int trackHeight = this.field_22790 - this.getTopMargin() - this.getBottomMargin();
            if (trackHeight <= 0) {
                return true;
            }
            float thumbHeight = Math.max(20.0f, (float)trackHeight / (float)this.totalContentHeight * (float)trackHeight);
            if ((float)trackHeight - thumbHeight <= 0.0f) {
                return true;
            }
            double scrollRatio = (double)this.getMaxScroll() / (double)((float)trackHeight - thumbHeight);
            this.scrollY += deltaY * scrollRatio;
            this.clampScroll();
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.method_25399() != null && this.method_25399().method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 265) {
            this.scrollY -= 10.0;
            this.clampScroll();
            return true;
        }
        if (keyCode == 264) {
            this.scrollY += 10.0;
            this.clampScroll();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void clampScroll() {
        int maxScroll;
        if (this.scrollY < 0.0) {
            this.scrollY = 0.0;
        }
        if (this.scrollY > (double)(maxScroll = this.getMaxScroll())) {
            this.scrollY = maxScroll;
        }
    }
}

