/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.atif.buildnotes.Buildnotes;
import net.atif.buildnotes.client.ClientImageTransferManager;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.CustomField;
import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.screen.EditBuildScreen;
import net.atif.buildnotes.gui.screen.ScrollableScreen;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.ReadOnlyMultiLineTextFieldWidget;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ViewBuildScreen
extends ScrollableScreen {
    private final Build build;
    private int currentImageIndex = 0;
    private final Map<String, ImageData> textureCache = new HashMap<String, ImageData>();
    private final Set<String> downloadingImages = new HashSet<String>();
    private DarkButtonWidget prevImageButton;
    private DarkButtonWidget nextImageButton;

    public ViewBuildScreen(class_437 parent, Build build) {
        super((class_2561)new class_2585(build.getName()), parent);
        this.build = build;
    }

    @Override
    protected int getTopMargin() {
        return 20;
    }

    @Override
    protected int getBottomMargin() {
        return 45;
    }

    @Override
    protected void initContent() {
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int yPos = this.getTopMargin();
        int panelSpacing = 5;
        int labelHeight = 12;
        int titlePanelHeight = 25;
        ReadOnlyMultiLineTextFieldWidget titleArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, contentX, yPos + 5, contentWidth, titlePanelHeight, this.field_22785.getString(), 1, false);
        titleArea.setInternalScissoring(false);
        this.addScrollableWidget(titleArea);
        int smallFieldHeight = 20;
        int fieldWidth = (contentWidth - 5) / 2;
        int coordsTextX = contentX + 50;
        ReadOnlyMultiLineTextFieldWidget coordsArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, coordsTextX, yPos += titlePanelHeight + 5, fieldWidth - 50, smallFieldHeight, this.build.getCoordinates(), 1, false);
        coordsArea.setInternalScissoring(false);
        this.addScrollableWidget(coordsArea);
        int dimensionX = contentX + fieldWidth + 5;
        int dimensionTextX = dimensionX + 65;
        ReadOnlyMultiLineTextFieldWidget dimensionArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, dimensionTextX, yPos, fieldWidth - 65, smallFieldHeight, this.build.getDimension(), 1, false);
        dimensionArea.setInternalScissoring(false);
        this.addScrollableWidget(dimensionArea);
        yPos += smallFieldHeight + 5;
        if (!this.build.getImageFileNames().isEmpty()) {
            int galleryHeight = (int)((double)contentWidth * 0.5625);
            yPos += galleryHeight + 5;
        }
        int descriptionHeight = 80;
        ReadOnlyMultiLineTextFieldWidget descriptionArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, contentX, yPos + 12, contentWidth, descriptionHeight, this.build.getDescription(), Integer.MAX_VALUE, true);
        descriptionArea.setInternalScissoring(false);
        this.addScrollableWidget(descriptionArea);
        int creditsHeight = 40;
        ReadOnlyMultiLineTextFieldWidget creditsArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, contentX, (yPos += descriptionHeight + 12 + 5) + 12, contentWidth, creditsHeight, this.build.getCredits(), Integer.MAX_VALUE, true);
        creditsArea.setInternalScissoring(false);
        this.addScrollableWidget(creditsArea);
        yPos += creditsHeight + 12 + 5;
        for (CustomField field : this.build.getCustomFields()) {
            int fieldHeight = 40;
            ReadOnlyMultiLineTextFieldWidget fieldArea = new ReadOnlyMultiLineTextFieldWidget(this.field_22793, contentX, yPos + 12, contentWidth, fieldHeight, field.getContent(), Integer.MAX_VALUE, true);
            fieldArea.setInternalScissoring(false);
            this.addScrollableWidget(fieldArea);
            yPos += fieldHeight + 12 + 5;
        }
        this.totalContentHeight = yPos;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int buttonsY = this.field_22790 - 20 - 12;
        UIHelper.createBottomButtonRow((class_437)this, buttonsY, 3, x -> {
            int idx = (x - UIHelper.getCenteredButtonStartX(this.field_22789, 3)) / 78;
            switch (idx) {
                case 0: {
                    this.method_37063((class_364)new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)new class_2588("gui.buildnotes.delete_button"), button -> this.confirmDelete()));
                    break;
                }
                case 1: {
                    this.method_37063((class_364)new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)new class_2588("gui.buildnotes.edit_button"), button -> this.open(new EditBuildScreen(this.parent, this.build))));
                    break;
                }
                case 2: {
                    this.method_37063((class_364)new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)new class_2588("gui.buildnotes.close_button"), button -> this.open(this.parent)));
                }
            }
        });
        if (!this.build.getImageFileNames().isEmpty()) {
            int contentWidth = (int)((double)this.field_22789 * 0.6);
            int contentX = (this.field_22789 - contentWidth) / 2;
            int galleryHeight = (int)((double)contentWidth * 0.5625);
            int galleryY = this.getTopMargin() + 25 + 5 + 20 + 5;
            int navButtonY = galleryY + (galleryHeight - 20) / 2;
            this.prevImageButton = new DarkButtonWidget(contentX - 25, navButtonY, 20, 20, (class_2561)new class_2585("<"), b -> this.switchImage(-1));
            this.nextImageButton = new DarkButtonWidget(contentX + contentWidth + 5, navButtonY, 20, 20, (class_2561)new class_2585(">"), b -> this.switchImage(1));
            this.addScrollableWidget(this.prevImageButton);
            this.addScrollableWidget(this.nextImageButton);
            this.updateNavButtons();
        }
    }

    @Override
    protected void renderContent(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int yPos = this.getTopMargin();
        int panelSpacing = 5;
        int labelHeight = 12;
        int titlePanelHeight = 25;
        ViewBuildScreen.method_25294((class_4587)matrices, (int)contentX, (int)yPos, (int)(contentX + contentWidth), (int)(yPos + titlePanelHeight), (int)0x77000000);
        int smallFieldHeight = 20;
        int fieldWidth = (contentWidth - 5) / 2;
        UIHelper.drawPanel(matrices, contentX, yPos += titlePanelHeight + 5, fieldWidth, smallFieldHeight);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Coords: ").method_27692(class_124.field_1080), (float)(contentX + 4), (float)yPos + (float)(smallFieldHeight - 8) / 2.0f + 1.0f, 0xCCCCCC);
        int dimensionX = contentX + fieldWidth + 5;
        UIHelper.drawPanel(matrices, dimensionX, yPos, fieldWidth, smallFieldHeight);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Dimension: ").method_27692(class_124.field_1080), (float)(dimensionX + 4), (float)yPos + (float)(smallFieldHeight - 8) / 2.0f + 1.0f, 0xCCCCCC);
        yPos += smallFieldHeight + 5;
        if (!this.build.getImageFileNames().isEmpty()) {
            int galleryBoxHeight = (int)((double)contentWidth * 0.5625);
            ViewBuildScreen.method_25294((class_4587)matrices, (int)contentX, (int)yPos, (int)(contentX + contentWidth), (int)(yPos + galleryBoxHeight), (int)0x77000000);
            String currentImageName = this.build.getImageFileNames().get(this.currentImageIndex);
            if (this.downloadingImages.contains(currentImageName)) {
                ViewBuildScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)new class_2585("Loading image...").method_27692(class_124.field_1054), (int)(this.field_22789 / 2), (int)(yPos + galleryBoxHeight / 2 - 4), (int)0xFFFFFF);
            } else {
                ImageData data = this.getImageDataForCurrentImage();
                if (data != null && data.textureId != null) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)data.textureId);
                    RenderSystem.enableBlend();
                    int boxWidth = contentWidth - 4;
                    int boxHeight = galleryBoxHeight - 4;
                    float imageAspect = (float)data.width / (float)data.height;
                    float boxAspect = (float)boxWidth / (float)boxHeight;
                    int renderWidth = boxWidth;
                    int renderHeight = boxHeight;
                    if (imageAspect > boxAspect) {
                        renderHeight = (int)((float)boxWidth / imageAspect);
                    } else {
                        renderWidth = (int)((float)boxHeight * imageAspect);
                    }
                    int renderX = contentX + 2 + (boxWidth - renderWidth) / 2;
                    int renderY = yPos + 2 + (boxHeight - renderHeight) / 2;
                    class_332.method_25290((class_4587)matrices, (int)renderX, (int)renderY, (float)0.0f, (float)0.0f, (int)renderWidth, (int)renderHeight, (int)renderWidth, (int)renderHeight);
                    RenderSystem.disableBlend();
                } else {
                    ViewBuildScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)new class_2585("Error or missing image").method_27692(class_124.field_1061), (int)(this.field_22789 / 2), (int)(yPos + galleryBoxHeight / 2 - 4), (int)0xFFFFFF);
                }
            }
            String counter = this.currentImageIndex + 1 + " / " + this.build.getImageFileNames().size();
            int counterWidth = this.field_22793.method_1727(counter);
            this.field_22793.method_1729(matrices, counter, (float)(contentX + contentWidth - counterWidth - 5), (float)(yPos + galleryBoxHeight - 12), 0xFFFFFF);
            yPos += galleryBoxHeight + 5;
        }
        int descriptionHeight = 80;
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Description:").method_27692(class_124.field_1080), (float)contentX, (float)yPos, 0xFFFFFF);
        ViewBuildScreen.method_25294((class_4587)matrices, (int)contentX, (int)(yPos + 12), (int)(contentX + contentWidth), (int)(yPos + 12 + descriptionHeight), (int)0x77000000);
        int creditsHeight = 40;
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Credits:").method_27692(class_124.field_1080), (float)contentX, (float)(yPos += descriptionHeight + 12 + 5), 0xFFFFFF);
        ViewBuildScreen.method_25294((class_4587)matrices, (int)contentX, (int)(yPos + 12), (int)(contentX + contentWidth), (int)(yPos + 12 + creditsHeight), (int)0x77000000);
        yPos += creditsHeight + 12 + 5;
        for (CustomField field : this.build.getCustomFields()) {
            int fieldHeight = 40;
            this.field_22793.method_30883(matrices, (class_2561)new class_2585(field.getTitle() + ":").method_27692(class_124.field_1080), (float)contentX, (float)yPos, 0xFFFFFF);
            ViewBuildScreen.method_25294((class_4587)matrices, (int)contentX, (int)(yPos + 12), (int)(contentX + contentWidth), (int)(yPos + 12 + fieldHeight), (int)0x77000000);
            yPos += fieldHeight + 12 + 5;
        }
    }

    private void switchImage(int direction) {
        int newIndex = this.currentImageIndex + direction;
        if (newIndex >= 0 && newIndex < this.build.getImageFileNames().size()) {
            this.currentImageIndex = newIndex;
            this.updateNavButtons();
        }
    }

    private void updateNavButtons() {
        if (this.prevImageButton != null) {
            boolean bl = this.prevImageButton.field_22763 = this.currentImageIndex > 0;
        }
        if (this.nextImageButton != null) {
            this.nextImageButton.field_22763 = this.currentImageIndex < this.build.getImageFileNames().size() - 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImageData getImageDataForCurrentImage() {
        if (this.build.getImageFileNames().isEmpty()) {
            return null;
        }
        String fileName = this.build.getImageFileNames().get(this.currentImageIndex);
        if (this.textureCache.containsKey(fileName)) {
            return this.textureCache.get(fileName);
        }
        try {
            Path imagePath = FabricLoader.getInstance().getConfigDir().resolve("buildnotes").resolve("images").resolve(this.build.getId().toString()).resolve(fileName);
            if (!Files.exists(imagePath, new LinkOption[0])) {
                if (this.downloadingImages.contains(fileName)) return null;
                Buildnotes.LOGGER.info("[CLIENT LOG 1] Local image not found for '{}'. Requesting from server.", (Object)fileName);
                this.downloadingImages.add(fileName);
                ClientImageTransferManager.requestImage(this.build.getId(), fileName, () -> this.field_22787.execute(() -> this.downloadingImages.remove(fileName)));
                return null;
            }
            try (InputStream stream = Files.newInputStream(imagePath, new OpenOption[0]);){
                class_1011 image = class_1011.method_4309((InputStream)stream);
                class_1043 texture = new class_1043(image);
                class_2960 textureId = this.field_22787.method_1531().method_4617("buildnotes_image_" + String.valueOf(this.build.getId()) + "_" + fileName.hashCode(), texture);
                ImageData data = new ImageData(textureId, image.method_4307(), image.method_4323());
                this.textureCache.put(fileName, data);
                ImageData imageData = data;
                return imageData;
            }
        }
        catch (Exception e) {
            this.textureCache.put(fileName, null);
            return null;
        }
    }

    private void confirmDelete() {
        Runnable onConfirm = () -> {
            DataManager.getInstance().deleteBuild(this.build);
            this.method_25419();
        };
        this.showConfirm((class_2561)new class_2585("Delete build \"" + this.build.getName() + "\"?"), onConfirm);
    }

    private void rebuild() {
        this.open(new ViewBuildScreen(this.parent, this.build));
    }

    @Override
    public void method_25419() {
        this.textureCache.values().forEach(data -> {
            if (data != null && data.textureId != null) {
                this.field_22787.method_1531().method_4615(data.textureId);
            }
        });
        super.method_25419();
    }

    private record ImageData(class_2960 textureId, int width, int height) {
    }
}

