/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.network;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.UUID;
import net.atif.buildnotes.Buildnotes;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.network.PacketIdentifiers;
import net.atif.buildnotes.server.ServerDataManager;
import net.atif.buildnotes.server.ServerImageTransferManager;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class ServerPacketHandler {
    private static boolean hasEditPermission(MinecraftServer server, class_3222 player) {
        return Buildnotes.PERMISSION_MANAGER.isAllowedToEdit(player);
    }

    public static void handleRequestInitialData(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        server.execute(() -> {
            ServerDataManager dataManager = Buildnotes.SERVER_DATA_MANAGER;
            List<Note> notes = dataManager.getNotes();
            List<Build> builds = dataManager.getBuilds();
            class_2540 responseBuf = new class_2540(Unpooled.buffer());
            responseBuf.method_34062(notes, (b, n) -> n.writeToBuf((class_2540)b));
            responseBuf.method_34062(builds, (b, B) -> B.writeToBuf((class_2540)b));
            ServerPlayNetworking.send((class_3222)player, (class_2960)PacketIdentifiers.INITIAL_SYNC_S2C, (class_2540)responseBuf);
        });
    }

    public static void handleSaveNote(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        Note receivedNote = Note.fromBuf(buf);
        server.execute(() -> {
            if (!ServerPacketHandler.hasEditPermission(server, player)) {
                return;
            }
            Buildnotes.SERVER_DATA_MANAGER.saveNote(receivedNote);
            for (class_3222 p : server.method_3760().method_14571()) {
                class_2540 copy = new class_2540(Unpooled.buffer());
                receivedNote.writeToBuf(copy);
                ServerPlayNetworking.send((class_3222)p, (class_2960)PacketIdentifiers.UPDATE_NOTE_S2C, (class_2540)copy);
            }
        });
    }

    public static void handleSaveBuild(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        Build receivedBuild = Build.fromBuf(buf);
        server.execute(() -> {
            if (!ServerPacketHandler.hasEditPermission(server, player)) {
                return;
            }
            Buildnotes.SERVER_DATA_MANAGER.saveBuild(receivedBuild);
            for (class_3222 p : server.method_3760().method_14571()) {
                class_2540 copy = new class_2540(Unpooled.buffer());
                receivedBuild.writeToBuf(copy);
                ServerPlayNetworking.send((class_3222)p, (class_2960)PacketIdentifiers.UPDATE_BUILD_S2C, (class_2540)copy);
            }
        });
    }

    public static void handleDeleteNote(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        UUID noteId = buf.method_10790();
        server.execute(() -> {
            if (!ServerPacketHandler.hasEditPermission(server, player)) {
                return;
            }
            Buildnotes.SERVER_DATA_MANAGER.deleteNote(noteId);
            class_2540 responseBuf = new class_2540(Unpooled.buffer());
            responseBuf.method_10797(noteId);
            for (class_3222 p : server.method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)p, (class_2960)PacketIdentifiers.DELETE_NOTE_S2C, (class_2540)responseBuf);
            }
        });
    }

    public static void handleDeleteBuild(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        UUID buildId = buf.method_10790();
        server.execute(() -> {
            if (!ServerPacketHandler.hasEditPermission(server, player)) {
                return;
            }
            Buildnotes.SERVER_DATA_MANAGER.deleteBuild(buildId);
            class_2540 responseBuf = new class_2540(Unpooled.buffer());
            responseBuf.method_10797(buildId);
            for (class_3222 p : server.method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)p, (class_2960)PacketIdentifiers.DELETE_BUILD_S2C, (class_2540)responseBuf);
            }
        });
    }

    public static void handleImageChunkUpload(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        UUID buildId = buf.method_10790();
        String filename = buf.method_19772();
        int totalChunks = buf.method_10816();
        int chunkIndex = buf.method_10816();
        byte[] data = buf.method_10795();
        server.execute(() -> ServerImageTransferManager.handleChunk(player, buildId, filename, totalChunks, chunkIndex, data));
    }

    public static void handleImageRequest(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        UUID buildId = buf.method_10790();
        String filename = buf.method_19772();
        server.execute(() -> Buildnotes.SERVER_DATA_MANAGER.sendImageToPlayer(player, buildId, filename));
    }
}

