/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.widget.list;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.atif.buildnotes.gui.widget.list.AbstractListWidget;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_5250;

public class NoteListWidget
extends AbstractListWidget<NoteEntry> {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");

    public NoteListWidget(MainScreen parent, class_310 client, int top, int bottom, int itemHeight) {
        super(parent, client, top, bottom, itemHeight);
    }

    public void setNotes(List<Note> notes) {
        this.method_25339();
        notes.forEach(note -> this.method_25321(new NoteEntry((Note)note)));
    }

    public Note getSelectedNote() {
        NoteEntry entry = (NoteEntry)this.method_25334();
        return entry != null ? entry.getNote() : null;
    }

    public void setSelected(NoteEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.parentScreen.onNoteSelected();
    }

    public class NoteEntry
    extends AbstractListWidget.Entry<NoteEntry> {
        private final Note note;
        private final String firstLine;
        private final String formattedDateTime;

        public NoteEntry(Note note) {
            String[] lines;
            this.note = note;
            String content = note.getContent();
            this.firstLine = content == null ? "" : ((lines = content.split("\n")).length > 0 ? lines[0] : "");
            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(note.getLastModified()), ZoneId.systemDefault());
            this.formattedDateTime = dateTime.format(DATE_TIME_FORMATTER);
        }

        public Note getNote() {
            return this.note;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_5250 scopeText = null;
            int scopeWidth = 0;
            if (this.note.getScope() != null) {
                switch (this.note.getScope()) {
                    case GLOBAL: {
                        scopeText = class_2561.method_43470((String)"Global").method_27692(class_124.field_1075);
                        break;
                    }
                    case SERVER: {
                        scopeText = class_2561.method_43470((String)"Server").method_27692(class_124.field_1060);
                    }
                }
            }
            if (scopeText != null) {
                scopeWidth = ((NoteListWidget)NoteListWidget.this).field_22740.field_1772.method_27525(scopeText);
            }
            int availableTitleWidth = entryWidth - 6;
            if (scopeText != null) {
                availableTitleWidth -= scopeWidth + 7;
            }
            String truncatedTitle = ((NoteListWidget)NoteListWidget.this).field_22740.field_1772.method_27523(this.note.getTitle(), availableTitleWidth);
            context.method_51433(((NoteListWidget)NoteListWidget.this).field_22740.field_1772, truncatedTitle, x + 2, y + 2, Colors.TEXT_PRIMARY, false);
            if (scopeText != null) {
                context.method_51439(((NoteListWidget)NoteListWidget.this).field_22740.field_1772, (class_2561)scopeText, x + entryWidth - scopeWidth - 4, y + 2, Colors.TEXT_PRIMARY, false);
            }
            class_5250 contentPreview = class_2561.method_43470((String)this.firstLine).method_27692(class_124.field_1080);
            String truncatedContent = ((NoteListWidget)NoteListWidget.this).field_22740.field_1772.method_27523(contentPreview.getString(), entryWidth - 6);
            context.method_51439(((NoteListWidget)NoteListWidget.this).field_22740.field_1772, (class_2561)class_2561.method_43470((String)truncatedContent), x + 2, y + 12, Colors.TEXT_MUTED, false);
            context.method_51433(((NoteListWidget)NoteListWidget.this).field_22740.field_1772, "Last Modified: " + this.formattedDateTime, x + 2, y + 22, Colors.TEXT_MUTED, false);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                NoteListWidget.this.setSelected(this);
                NoteListWidget.this.handleEntryClick(this);
                return true;
            }
            return false;
        }
    }
}

