package net.atif.buildnotes.gui.screen;

import net.atif.buildnotes.gui.helper.UIHelper;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public abstract class BaseScreen extends class_437 {

    protected final class_437 parent;

    protected BaseScreen(class_2561 title, class_437 parent) {
        super(title);
        this.parent = parent;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.field_22787 != null) {
            this.field_22787.field_1774.method_1462(true);
        }
    }

    /**
     * Default close behaviour: stop repeat events and return to parent screen.
     * Subclasses may override if they need different behaviour, but calling super.close()
     * will still perform the default.
     */
    @Override
    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.field_1774.method_1462(false);
            this.field_22787.method_1507(this.parent);
        } else {
            super.method_25419();
        }
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    /**
     * Convenience to open another screen safely.
     */
    protected void open(class_437 next) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(next);
        }
    }

    /**
     * Convenience to show a standard confirm dialog whose cancel action returns to this screen.
     */
    protected void showConfirm(net.minecraft.class_2561 message, Runnable onConfirm) {
        UIHelper.showConfirmDialog(this, message, onConfirm);
    }
}
