package net.atif.buildnotes.gui.screen;

import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.data.TabType;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.ReadOnlyMultiLineTextFieldWidget;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ViewNoteScreen extends BaseScreen {

    private final Note note;

    private ReadOnlyMultiLineTextFieldWidget titleArea;
    private ReadOnlyMultiLineTextFieldWidget contentArea;

    public ViewNoteScreen(class_437 parent, Note note) {
        super(new class_2585(note.getTitle()), parent);
        this.note = note;
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        int buttonsY = this.field_22790 - UIHelper.BUTTON_HEIGHT - UIHelper.BOTTOM_PADDING;
        UIHelper.createBottomButtonRow(this, buttonsY, 3, x -> {
            int idx = (x - UIHelper.getCenteredButtonStartX(this.field_22789, 3)) / (UIHelper.BUTTON_WIDTH + UIHelper.BUTTON_SPACING);
            switch (idx) {
                case 0 -> this.method_37063(new DarkButtonWidget(x, buttonsY, UIHelper.BUTTON_WIDTH, UIHelper.BUTTON_HEIGHT,
                        new class_2588("gui.buildnotes.delete_button"), button -> confirmDelete()));
                case 1 -> this.method_37063(new DarkButtonWidget(x, buttonsY, UIHelper.BUTTON_WIDTH, UIHelper.BUTTON_HEIGHT,
                        new class_2588("gui.buildnotes.edit_button"), button -> this.field_22787.method_1507(new EditNoteScreen(this.parent, this.note))));
                case 2 -> this.method_37063(new DarkButtonWidget(x, buttonsY, UIHelper.BUTTON_WIDTH, UIHelper.BUTTON_HEIGHT,
                        new class_2588("gui.buildnotes.close_button"), button -> this.field_22787.method_1507(parent)));
            }
        });

        int contentWidth = (int) (this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int topMargin = 20;
        int titlePanelHeight = 25;
        int panelSpacing = 5;
        int bottomMargin = 45;

        // --- Title Widget ---
        this.titleArea = new ReadOnlyMultiLineTextFieldWidget(
                this.field_22793,
                contentX,
                topMargin + 5,
                contentWidth,
                titlePanelHeight,
                this.note.getTitle(),
                1,
                false
        );
        this.method_25429(this.titleArea);

        int contentPanelY = topMargin + titlePanelHeight + panelSpacing;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        int contentPanelHeight = contentPanelBottom - contentPanelY;

        // --- Content Widget ---
        this.contentArea = new ReadOnlyMultiLineTextFieldWidget(
                this.field_22793,
                contentX,
                contentPanelY,
                contentWidth,
                contentPanelHeight,
                note.getContent(),
                Integer.MAX_VALUE,
                true
        );
        this.method_25429(this.contentArea);
    }

    private void confirmDelete() {
        Runnable onConfirm = () -> {
            DataManager.getInstance().deleteNote(this.note);
            this.method_25419();
        };
        UIHelper.showConfirmDialog(this, new class_2585("Delete note \"" + note.getTitle() + "\"?"), onConfirm);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);

        int contentWidth = (int) (this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int topMargin = 20;
        int titlePanelHeight = 25;
        int panelSpacing = 5;
        int bottomMargin = 45;

        // --- Title Panel ---
        UIHelper.drawPanel(matrices, contentX, topMargin, contentWidth, titlePanelHeight);
        this.titleArea.method_25394(matrices, mouseX, mouseY, delta);

        // --- Content Panel ---
        int contentPanelY = topMargin + titlePanelHeight + panelSpacing;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        UIHelper.drawPanel(matrices, contentX, contentPanelY, contentWidth, contentPanelBottom - contentPanelY);
        this.contentArea.method_25394(matrices, mouseX, mouseY, delta);

        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        // Pass key events to both widgets for copying/navigation
        if (this.titleArea.method_25404(keyCode, scanCode, modifiers)) return true;
        if (this.contentArea.method_25404(keyCode, scanCode, modifiers)) return true;
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    // --- Delegate scrolling to the widget ---
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        // Pass scroll events to the widget under the mouse
        if (this.titleArea.method_25405(mouseX, mouseY)) {
            return this.titleArea.method_25401(mouseX, mouseY, amount);
        }
        if (this.contentArea.method_25405(mouseX, mouseY)) {
            return this.contentArea.method_25401(mouseX, mouseY, amount);
        }
        return false;
    }
}