package net.atif.buildnotes.gui.widget.list;

import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_4587;
import net.atif.buildnotes.data.Scope;
import java.util.List;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class NoteListWidget extends AbstractListWidget<NoteListWidget.NoteEntry> {

    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");

    public NoteListWidget(MainScreen parent, class_310 client, int width, int height, int top, int bottom, int itemHeight) {
        super(parent, client, top, bottom, itemHeight);
    }

    public void setNotes(List<Note> notes) {
        this.method_25339();
        notes.forEach(note -> this.method_25321(new NoteEntry(note)));
    }

    public Note getSelectedNote() {
            NoteEntry entry = method_25334();
        return entry != null ? entry.getNote() : null;
    }

    public NoteEntry getPublicEntry(int index) {
        return this.method_25326(index);
    }

    @Override
    public void setSelected(NoteEntry entry) {
        super.method_25313(entry);
        parentScreen.onNoteSelected(); // Notify the parent screen
    }

    public class NoteEntry extends class_350.class_351<NoteEntry> {
        private final Note note;
        private final String firstLine;
        private final String formattedDateTime;

        public NoteEntry(Note note) {
            this.note = note;
            this.firstLine = note.getContent().split("\n")[0];

            LocalDateTime dateTime = LocalDateTime.ofInstant(
                    Instant.ofEpochSecond(note.getLastModified()), ZoneId.systemDefault()
            );

            this.formattedDateTime = dateTime.format(DATE_TIME_FORMATTER);
        }

        public Note getNote() {
            return this.note;
        }


        @Override
        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            // Title
            field_22740.field_1772.method_1729(matrices, note.getTitle(), x + 2, y + 2, 0xFFFFFF);

            // Content Preview
            class_2561 contentPreview = new class_2585(firstLine).method_27692(class_124.field_1080);
            String truncated = field_22740.field_1772.method_27523(contentPreview.getString(), entryWidth - 4);
            field_22740.field_1772.method_30883(matrices, new class_2585(truncated), x + 2, y + 12, 0xCCCCCC);

            // Date/Time with new label
            field_22740.field_1772.method_1729(matrices, "Last Modified: " + this.formattedDateTime, x + 2, y + 22, 0xCCCCCC);

            class_2561 scopeText = null;
            if (note.getScope() != null) { // Add null check for safety
                switch (note.getScope()) {
                    case GLOBAL -> scopeText = new class_2585("Global").method_27692(class_124.field_1075);
                    case SERVER -> scopeText = new class_2585("Server").method_27692(class_124.field_1060);
                    // We don't draw an indicator for WORLD scope to keep the UI clean
                }
            }

            if (scopeText != null) {
                int scopeWidth = field_22740.field_1772.method_27525(scopeText);
                field_22740.field_1772.method_30883(matrices, scopeText, x + entryWidth - scopeWidth - 7, y + 2, 0xFFFFFF);
            }
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                NoteListWidget.this.setSelected(this);

                NoteListWidget.this.handleEntryClick(this);
                return true;
            }
            return false;
        }
    }
}