/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.client;

import io.netty.buffer.Unpooled;
import net.atif.buildnotes.client.ClientCache;
import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.client.KeyBinds;
import net.atif.buildnotes.data.PermissionLevel;
import net.atif.buildnotes.data.TabType;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.atif.buildnotes.network.ClientPacketHandler;
import net.atif.buildnotes.network.PacketIdentifiers;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_634;

@Environment(value=EnvType.CLIENT)
public class BuildnotesClient
implements ClientModInitializer {
    public void onInitializeClient() {
        KeyBinds.register();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (KeyBinds.openGuiKey.method_1436()) {
                if (client.field_1755 != null) continue;
                client.method_1507((class_437)new MainScreen(TabType.NOTES));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.HANDSHAKE_S2C, this::handleHandshake);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.INITIAL_SYNC_S2C, ClientPacketHandler::handleInitialSync);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.UPDATE_NOTE_S2C, ClientPacketHandler::handleUpdateNote);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.UPDATE_BUILD_S2C, ClientPacketHandler::handleUpdateBuild);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.DELETE_NOTE_S2C, ClientPacketHandler::handleDeleteNote);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.DELETE_BUILD_S2C, ClientPacketHandler::handleDeleteBuild);
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> client.execute(() -> {
            ClientSession.leaveServer();
            ClientCache.clear();
        }));
    }

    private void handleHandshake(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        PermissionLevel permission = (PermissionLevel)buf.method_10818(PermissionLevel.class);
        client.execute(() -> {
            ClientSession.joinServer(permission);
            ClientPlayNetworking.send((class_2960)PacketIdentifiers.REQUEST_DATA_C2S, (class_2540)new class_2540(Unpooled.buffer()));
        });
    }
}

