/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.atif.buildnotes.data.BaseEntry;
import net.atif.buildnotes.data.CustomField;
import net.atif.buildnotes.data.Scope;
import net.minecraft.class_2540;

public class Build
extends BaseEntry {
    private String name;
    private String coordinates;
    private String dimension;
    private String description;
    private String credits;
    private final List<CustomField> customFields;
    private List<String> imageFileNames;

    public Build(String name, String coordinates, String dimension, String description, String credits) {
        this.name = name;
        this.coordinates = coordinates;
        this.dimension = dimension;
        this.description = description;
        this.credits = credits;
        this.customFields = new ArrayList<CustomField>();
        this.imageFileNames = new ArrayList<String>();
    }

    private Build(UUID id, long lastModified, Scope scope, String name, String coords, String dim, String desc, String cred, List<String> images, List<CustomField> fields) {
        super(id, lastModified, scope);
        this.name = name;
        this.coordinates = coords;
        this.dimension = dim;
        this.description = desc;
        this.credits = cred;
        this.imageFileNames = images;
        this.customFields = fields;
    }

    @Override
    public UUID getId() {
        return super.getId();
    }

    public String getName() {
        return this.name;
    }

    public String getCoordinates() {
        return this.coordinates;
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCredits() {
        return this.credits;
    }

    public List<CustomField> getCustomFields() {
        return this.customFields;
    }

    public List<String> getImageFileNames() {
        if (this.imageFileNames == null) {
            this.imageFileNames = new ArrayList<String>();
        }
        return this.imageFileNames;
    }

    @Override
    public long getLastModified() {
        return super.getLastModified();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCredits(String credits) {
        this.credits = credits;
    }

    public void writeToBuf(class_2540 buf) {
        buf.method_10797(this.getId());
        buf.writeLong(this.getLastModified());
        buf.method_10817((Enum)this.getScope());
        buf.method_10814(this.name);
        buf.method_10814(this.coordinates);
        buf.method_10814(this.dimension);
        buf.method_10814(this.description);
        buf.method_10814(this.credits);
        buf.method_34062(this.imageFileNames, class_2540::method_10814);
        buf.method_34062(this.customFields, (b, field) -> field.writeToBuf((class_2540)b));
    }

    public static Build fromBuf(class_2540 buf) {
        UUID id = buf.method_10790();
        long lastModified = buf.readLong();
        Scope scope = (Scope)buf.method_10818(Scope.class);
        String name = buf.method_19772();
        String coords = buf.method_19772();
        String dim = buf.method_19772();
        String desc = buf.method_19772();
        String cred = buf.method_19772();
        List images = buf.method_34066(class_2540::method_19772);
        List fields = buf.method_34066(CustomField::fromBuf);
        return new Build(id, lastModified, scope, name, coords, dim, desc, cred, images, fields);
    }
}

