/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.CustomField;
import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.data.Scope;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.screen.BaseScreen;
import net.atif.buildnotes.gui.screen.ScrollableScreen;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.MultiLineTextFieldWidget;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class EditBuildScreen
extends ScrollableScreen {
    private final Build build;
    private int currentImageIndex = 0;
    private final Map<String, ImageData> textureCache = new HashMap<String, ImageData>();
    private DarkButtonWidget prevImageButton;
    private DarkButtonWidget nextImageButton;
    private DarkButtonWidget deleteImageButton;
    private MultiLineTextFieldWidget nameField;
    private MultiLineTextFieldWidget coordsField;
    private MultiLineTextFieldWidget dimensionField;
    private MultiLineTextFieldWidget descriptionField;
    private MultiLineTextFieldWidget designerField;
    private final Map<CustomField, MultiLineTextFieldWidget> customFieldWidgets = new LinkedHashMap<CustomField, MultiLineTextFieldWidget>();
    private MultiLineTextFieldWidget lastFocusedTextField;
    private DarkButtonWidget scopeToggleButton;

    public EditBuildScreen(class_437 parent, Build build) {
        super((class_2561)new class_2588("gui.buildnotes.edit_build_title"), parent);
        this.build = build;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int buttonsY = this.field_22790 - 20 - 12;
        List<class_2588> bottomTexts = List.of(new class_2585("Save"), new class_2588("gui.buildnotes.close_button"));
        UIHelper.createBottomButtonRow((class_437)this, buttonsY, bottomTexts, (index, x, width) -> {
            if (index == 0) {
                this.method_37063((class_364)new DarkButtonWidget(x, buttonsY, width, 20, (class_2561)bottomTexts.get(0), button -> this.saveBuild()));
            } else {
                this.method_37063((class_364)new DarkButtonWidget(x, buttonsY, width, 20, (class_2561)bottomTexts.get(1), button -> this.method_25419()));
            }
        });
        int topRowY = buttonsY - 20 - 5;
        List<class_2585> topTexts = List.of(new class_2585("Coords"), new class_2585("Dimension"), new class_2585("Biome"), new class_2585("Add Images"), new class_2585("Add Field"), this.getScopeButtonText());
        UIHelper.createBottomButtonRow((class_437)this, topRowY, topTexts, (index, x, width) -> {
            switch (index) {
                case 0: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topTexts.get(0), b -> this.insertCoords()));
                    break;
                }
                case 1: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topTexts.get(1), b -> this.insertDimension()));
                    break;
                }
                case 2: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topTexts.get(2), b -> this.insertBiome()));
                    break;
                }
                case 3: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topTexts.get(3), b -> this.openImageSelectionDialog()));
                    break;
                }
                case 4: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topTexts.get(4), b -> {
                        this.saveBuild();
                        this.open(new RequestFieldTitleScreen(this, this::addCustomField));
                    }));
                    break;
                }
                case 5: {
                    this.method_37063((class_364)new DarkButtonWidget(x, topRowY, width, 20, (class_2561)topTexts.get(5), button -> {
                        this.cycleScope();
                        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                    }));
                }
            }
        });
        if (!this.build.getImageFileNames().isEmpty()) {
            int contentWidth = (int)((double)this.field_22789 * 0.6);
            int contentX = (this.field_22789 - contentWidth) / 2;
            int galleryHeight = (int)((double)contentWidth * 0.5625);
            int galleryY = this.getTopMargin() + 25 + 5 + 20 + 5;
            int navButtonY = galleryY + (galleryHeight - 20) / 2;
            this.prevImageButton = new DarkButtonWidget(contentX - 25, navButtonY, 20, 20, (class_2561)new class_2585("<"), b -> this.switchImage(-1));
            this.nextImageButton = new DarkButtonWidget(contentX + contentWidth + 5, navButtonY, 20, 20, (class_2561)new class_2585(">"), b -> this.switchImage(1));
            this.deleteImageButton = new DarkButtonWidget(contentX + contentWidth - 22, galleryY + 2, 20, 20, (class_2561)new class_2585("X"), b -> this.removeCurrentImage());
            this.addScrollableWidget(this.prevImageButton);
            this.addScrollableWidget(this.nextImageButton);
            this.addScrollableWidget(this.deleteImageButton);
            this.updateNavButtons();
        }
        this.method_20085(this.nameField);
    }

    @Override
    protected void initContent() {
        this.customFieldWidgets.clear();
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int yPos = this.getTopMargin();
        int panelSpacing = 5;
        int labelHeight = 12;
        this.nameField = new MultiLineTextFieldWidget(this.field_22793, contentX, yPos + 5, contentWidth, 25, this.build.getName(), "Build Name", 1, false);
        this.nameField.setInternalScissoring(false);
        this.addScrollableWidget(this.nameField);
        int smallFieldHeight = 20;
        int fieldWidth = (contentWidth - 5) / 2;
        this.coordsField = new MultiLineTextFieldWidget(this.field_22793, contentX + 50, yPos += 30, fieldWidth - 50, smallFieldHeight, this.build.getCoordinates(), "X, Y, Z", 1, false);
        this.coordsField.setInternalScissoring(false);
        this.addScrollableWidget(this.coordsField);
        int dimensionX = contentX + fieldWidth + 5;
        this.dimensionField = new MultiLineTextFieldWidget(this.field_22793, dimensionX + 65, yPos, fieldWidth - 65, smallFieldHeight, this.build.getDimension(), "e.g., Overworld", 1, false);
        this.dimensionField.setInternalScissoring(false);
        this.addScrollableWidget(this.dimensionField);
        yPos += smallFieldHeight + 5;
        if (!this.build.getImageFileNames().isEmpty()) {
            int galleryHeight = (int)((double)contentWidth * 0.5625);
            yPos += galleryHeight + 5;
        }
        this.descriptionField = new MultiLineTextFieldWidget(this.field_22793, contentX, yPos += 12, contentWidth, 80, this.build.getDescription(), "Build Description", Integer.MAX_VALUE, true);
        this.descriptionField.setInternalScissoring(false);
        this.addScrollableWidget(this.descriptionField);
        yPos += 85;
        this.designerField = new MultiLineTextFieldWidget(this.field_22793, contentX, yPos += 12, contentWidth, 40, this.build.getCredits(), "Designer Credits", Integer.MAX_VALUE, true);
        this.designerField.setInternalScissoring(false);
        this.addScrollableWidget(this.designerField);
        yPos += 45;
        for (CustomField field : this.build.getCustomFields()) {
            int customRemoveBtnWidth = 20;
            int fieldWidgetWidth = contentWidth - customRemoveBtnWidth - 5;
            MultiLineTextFieldWidget fieldArea = new MultiLineTextFieldWidget(this.field_22793, contentX, yPos += 12, fieldWidgetWidth, 40, field.getContent(), "", Integer.MAX_VALUE, true);
            fieldArea.setInternalScissoring(false);
            this.addScrollableWidget(fieldArea);
            this.customFieldWidgets.put(field, fieldArea);
            DarkButtonWidget removeButton = new DarkButtonWidget(contentX + fieldWidgetWidth + 5, yPos, customRemoveBtnWidth, 20, (class_2561)new class_2585("X"), button -> this.removeCustomField(field));
            this.addScrollableWidget(removeButton);
            yPos += 45;
        }
        this.totalContentHeight = yPos;
    }

    @Override
    protected void renderContent(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int contentWidth = (int)((double)this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int yPos = this.getTopMargin();
        int panelSpacing = 5;
        int labelHeight = 12;
        UIHelper.drawPanel(matrices, contentX, yPos, contentWidth, 25);
        int smallFieldHeight = 20;
        int fieldWidth = (contentWidth - 5) / 2;
        UIHelper.drawPanel(matrices, contentX, yPos += 30, fieldWidth, smallFieldHeight);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Coords: ").method_27692(class_124.field_1080), (float)(contentX + 4), (float)yPos + (float)(smallFieldHeight - 8) / 2.0f + 1.0f, 0xCCCCCC);
        int dimensionX = contentX + fieldWidth + 5;
        UIHelper.drawPanel(matrices, dimensionX, yPos, fieldWidth, smallFieldHeight);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Dimension: ").method_27692(class_124.field_1080), (float)(dimensionX + 4), (float)yPos + (float)(smallFieldHeight - 8) / 2.0f + 1.0f, 0xCCCCCC);
        yPos += smallFieldHeight + 5;
        if (!this.build.getImageFileNames().isEmpty()) {
            int galleryBoxHeight = (int)((double)contentWidth * 0.5625);
            EditBuildScreen.method_25294((class_4587)matrices, (int)contentX, (int)yPos, (int)(contentX + contentWidth), (int)(yPos + galleryBoxHeight), (int)0x77000000);
            ImageData data = this.getImageDataForCurrentImage();
            if (data != null && data.textureId != null) {
                RenderSystem.setShaderTexture((int)0, (class_2960)data.textureId);
                RenderSystem.enableBlend();
                int boxWidth = contentWidth - 4;
                int boxHeight = galleryBoxHeight - 4;
                float imageAspect = (float)data.width / (float)data.height;
                float boxAspect = (float)boxWidth / (float)boxHeight;
                int renderWidth = boxWidth;
                int renderHeight = boxHeight;
                if (imageAspect > boxAspect) {
                    renderHeight = (int)((float)boxWidth / imageAspect);
                } else {
                    renderWidth = (int)((float)boxHeight * imageAspect);
                }
                int renderX = contentX + 2 + (boxWidth - renderWidth) / 2;
                int renderY = yPos + 2 + (boxHeight - renderHeight) / 2;
                class_332.method_25290((class_4587)matrices, (int)renderX, (int)renderY, (float)0.0f, (float)0.0f, (int)renderWidth, (int)renderHeight, (int)renderWidth, (int)renderHeight);
                RenderSystem.disableBlend();
            } else {
                EditBuildScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)new class_2585("Error loading image").method_27692(class_124.field_1061), (int)(this.field_22789 / 2), (int)(yPos + galleryBoxHeight / 2 - 4), (int)0xFFFFFF);
            }
            String counter = this.currentImageIndex + 1 + " / " + this.build.getImageFileNames().size();
            int counterWidth = this.field_22793.method_1727(counter);
            this.field_22793.method_1729(matrices, counter, (float)(contentX + contentWidth - counterWidth - 5), (float)(yPos + galleryBoxHeight - 12), 0xFFFFFF);
            yPos += galleryBoxHeight + 5;
        }
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Description:").method_27692(class_124.field_1080), (float)contentX, (float)yPos, 0xFFFFFF);
        UIHelper.drawPanel(matrices, contentX, yPos += 12, contentWidth, 80);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Designer/Credits:").method_27692(class_124.field_1080), (float)contentX, (float)(yPos += 85), 0xFFFFFF);
        UIHelper.drawPanel(matrices, contentX, yPos += 12, contentWidth, 40);
        yPos += 45;
        for (CustomField field : this.build.getCustomFields()) {
            this.field_22793.method_30883(matrices, (class_2561)new class_2585(field.getTitle() + ":").method_27692(class_124.field_1080), (float)contentX, (float)yPos, 0xFFFFFF);
            UIHelper.drawPanel(matrices, contentX, yPos += 12, contentWidth, 40);
            yPos += 45;
        }
        EditBuildScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)8, (int)0xFFFFFF);
    }

    private void switchImage(int direction) {
        int newIndex = this.currentImageIndex + direction;
        if (newIndex >= 0 && newIndex < this.build.getImageFileNames().size()) {
            this.currentImageIndex = newIndex;
            this.updateNavButtons();
        }
    }

    private void removeCurrentImage() {
        if (this.build.getImageFileNames().isEmpty()) {
            return;
        }
        String fileNameToRemove = this.build.getImageFileNames().get(this.currentImageIndex);
        this.build.getImageFileNames().remove(fileNameToRemove);
        if (this.currentImageIndex >= this.build.getImageFileNames().size()) {
            this.currentImageIndex = Math.max(0, this.build.getImageFileNames().size() - 1);
        }
        this.rebuild();
    }

    private void updateNavButtons() {
        if (this.prevImageButton != null) {
            boolean bl = this.prevImageButton.field_22763 = this.currentImageIndex > 0;
        }
        if (this.nextImageButton != null) {
            this.nextImageButton.field_22763 = this.currentImageIndex < this.build.getImageFileNames().size() - 1;
        }
    }

    private ImageData getImageDataForCurrentImage() {
        block10: {
            ImageData imageData;
            block11: {
                if (this.build.getImageFileNames().isEmpty()) {
                    return null;
                }
                String fileName = this.build.getImageFileNames().get(this.currentImageIndex);
                if (this.textureCache.containsKey(fileName)) {
                    return this.textureCache.get(fileName);
                }
                Path imagePath = FabricLoader.getInstance().getConfigDir().resolve("buildnotes").resolve("images").resolve(this.build.getId().toString()).resolve(fileName);
                if (!Files.exists(imagePath, new LinkOption[0])) break block10;
                InputStream stream = Files.newInputStream(imagePath, new OpenOption[0]);
                try {
                    class_1011 image = class_1011.method_4309((InputStream)stream);
                    class_1043 texture = new class_1043(image);
                    class_2960 textureId = this.field_22787.method_1531().method_4617("buildnotes_image_" + String.valueOf(this.build.getId()) + "_" + fileName.hashCode(), texture);
                    ImageData data = new ImageData(textureId, image.method_4307(), image.method_4323());
                    this.textureCache.put(fileName, data);
                    imageData = data;
                    if (stream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.textureCache.put(fileName, null);
                    }
                }
                stream.close();
            }
            return imageData;
        }
        return null;
    }

    @Override
    public void method_25419() {
        this.textureCache.values().forEach(data -> {
            if (data != null && data.textureId != null) {
                this.field_22787.method_1531().method_4615(data.textureId);
            }
        });
        this.saveBuild();
        super.method_25419();
    }

    private void rebuild() {
        this.saveBuild();
        this.open(new EditBuildScreen(this.parent, this.build));
    }

    @Override
    protected int getTopMargin() {
        return 20;
    }

    @Override
    protected int getBottomMargin() {
        return 70;
    }

    private void saveBuild() {
        this.build.setName(this.nameField.getText());
        this.build.setCoordinates(this.coordsField.getText());
        this.build.setDimension(this.dimensionField.getText());
        this.build.setDescription(this.descriptionField.getText());
        this.build.setCredits(this.designerField.getText());
        for (Map.Entry<CustomField, MultiLineTextFieldWidget> entry : this.customFieldWidgets.entrySet()) {
            entry.getKey().setContent(entry.getValue().getText());
        }
        this.build.updateTimestamp();
        DataManager.getInstance().saveBuild(this.build);
    }

    private void insertTextAtLastFocus(String text) {
        if (this.lastFocusedTextField != null) {
            this.lastFocusedTextField.insertText(text);
            this.method_25395(this.lastFocusedTextField);
        }
    }

    private void insertCoords() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        String coords = String.format("%.0f, %.0f, %.0f", this.field_22787.field_1724.method_23317(), this.field_22787.field_1724.method_23318(), this.field_22787.field_1724.method_23321());
        this.insertTextAtLastFocus(coords);
    }

    private void insertDimension() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        String dim = this.field_22787.field_1724.field_6002.method_27983().method_29177().toString();
        this.insertTextAtLastFocus(dim);
    }

    private void insertBiome() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null || this.field_22787.field_1687 == null) {
            return;
        }
        class_2338 playerPos = this.field_22787.field_1724.method_24515();
        String biomeId = this.field_22787.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)((class_1959)this.field_22787.field_1687.method_23753(playerPos).comp_349())).toString();
        this.insertTextAtLastFocus(biomeId);
    }

    private void openImageSelectionDialog() {
        new Thread(() -> {
            String selectedFiles = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Select Image(s)", null, null, (CharSequence)"Image Files (*.png, *.jpg, *.jpeg)", (boolean)true);
            this.field_22787.execute(() -> {
                if (selectedFiles != null) {
                    this.processSelectedFiles(selectedFiles.split("\\|"));
                }
                if (this.field_22787 != null) {
                    long handle = this.field_22787.method_22683().method_4490();
                    GLFW.glfwRestoreWindow((long)handle);
                    GLFW.glfwFocusWindow((long)handle);
                }
            });
        }).start();
    }

    private void processSelectedFiles(String[] paths) {
        new Thread(() -> {
            for (String pathStr : paths) {
                try {
                    Path sourcePath = Path.of(pathStr, new String[0]);
                    String fileName = sourcePath.getFileName().toString().toLowerCase();
                    if (!fileName.endsWith(".png") && !fileName.endsWith(".jpg") && !fileName.endsWith(".jpeg")) continue;
                    Path destDir = FabricLoader.getInstance().getConfigDir().resolve("buildnotes").resolve("images").resolve(this.build.getId().toString());
                    Files.createDirectories(destDir, new FileAttribute[0]);
                    Path destPath = destDir.resolve(fileName);
                    Files.copy(sourcePath, destPath, StandardCopyOption.REPLACE_EXISTING);
                    if (this.build.getImageFileNames().contains(fileName)) continue;
                    this.build.getImageFileNames().add(fileName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.field_22787.execute(this::rebuild);
        }).start();
    }

    private void addCustomField(String title) {
        if (title == null || title.isBlank()) {
            return;
        }
        this.build.getCustomFields().add(new CustomField(title, ""));
        this.rebuild();
    }

    private void removeCustomField(CustomField field) {
        this.build.getCustomFields().remove(field);
        this.rebuild();
    }

    private void cycleScope() {
        Scope currentScope = this.build.getScope();
        if (ClientSession.isOnServer() && ClientSession.hasEditPermission()) {
            if (currentScope == Scope.WORLD) {
                this.build.setScope(Scope.GLOBAL);
            } else if (currentScope == Scope.GLOBAL) {
                this.build.setScope(Scope.SERVER);
            } else {
                this.build.setScope(Scope.WORLD);
            }
        } else {
            this.build.setScope(currentScope == Scope.WORLD ? Scope.GLOBAL : Scope.WORLD);
        }
    }

    private class_2585 getScopeButtonText() {
        Scope currentScope = this.build.getScope();
        String scopeName = currentScope == Scope.GLOBAL ? "Global" : (currentScope == Scope.SERVER ? "Server (Shared)" : (this.field_22787 != null && this.field_22787.method_1496() ? "World" : "Per-Server"));
        return new class_2585("Scope: " + scopeName);
    }

    public void method_25395(class_364 focused) {
        super.method_25395(focused);
        if (focused instanceof MultiLineTextFieldWidget) {
            MultiLineTextFieldWidget widget;
            this.lastFocusedTextField = widget = (MultiLineTextFieldWidget)focused;
        }
    }

    private record ImageData(class_2960 textureId, int width, int height) {
    }

    private static class RequestFieldTitleScreen
    extends BaseScreen {
        private final Consumer<String> onConfirm;
        private class_342 titleField;

        protected RequestFieldTitleScreen(class_437 parent, Consumer<String> onConfirm) {
            super((class_2561)new class_2585("Enter Field Title"), parent);
            this.onConfirm = onConfirm;
        }

        @Override
        protected void method_25426() {
            super.method_25426();
            int panelW = 200;
            int panelX = (this.field_22789 - panelW) / 2;
            int panelY = (this.field_22790 - 100) / 2;
            this.titleField = new class_342(this.field_22793, panelX + 10, panelY + 20, panelW - 20, 20, (class_2561)new class_2585(""));
            this.method_25429((class_364)this.titleField);
            int buttonsY = panelY + 60;
            int btnStartX = (this.field_22789 - 178) / 2;
            this.method_37063((class_364)new DarkButtonWidget(btnStartX, buttonsY, 85, 20, (class_2561)new class_2585("Confirm"), button -> {
                this.onConfirm.accept(this.titleField.method_1882());
                this.open(this.parent);
            }));
            this.method_37063((class_364)new DarkButtonWidget(btnStartX + 95, buttonsY, 85, 20, (class_2561)new class_2585("Cancel"), button -> this.open(this.parent)));
            this.method_20085((class_364)this.titleField);
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.parent.method_25394(matrices, -1, -1, delta);
            int panelW = 200;
            int panelH = 100;
            int panelX = (this.field_22789 - panelW) / 2;
            int panelY = (this.field_22790 - panelH) / 2;
            UIHelper.drawPanel(matrices, panelX, panelY, panelW, panelH);
            RequestFieldTitleScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)(panelY + 8), (int)0xFFFFFF);
            this.titleField.method_25394(matrices, mouseX, mouseY, delta);
            super.method_25394(matrices, mouseX, mouseY, delta);
        }
    }
}

