/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.screen;

import java.util.List;
import java.util.stream.Collectors;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.data.TabType;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.screen.BaseScreen;
import net.atif.buildnotes.gui.screen.EditBuildScreen;
import net.atif.buildnotes.gui.screen.EditNoteScreen;
import net.atif.buildnotes.gui.screen.ViewBuildScreen;
import net.atif.buildnotes.gui.screen.ViewNoteScreen;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.MultiLineTextFieldWidget;
import net.atif.buildnotes.gui.widget.TabButtonWidget;
import net.atif.buildnotes.gui.widget.list.BuildListWidget;
import net.atif.buildnotes.gui.widget.list.NoteListWidget;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class MainScreen
extends BaseScreen {
    private TabButtonWidget notesTab;
    private TabButtonWidget buildsTab;
    private DarkButtonWidget editButton;
    private DarkButtonWidget deleteButton;
    private DarkButtonWidget addButton;
    private DarkButtonWidget openButton;
    private DarkButtonWidget closeButton;
    private NoteListWidget noteListWidget;
    private BuildListWidget buildListWidget;
    private MultiLineTextFieldWidget searchField;
    private String searchTerm = "";
    private TabType currentTab;

    public MainScreen(TabType startTab) {
        super((class_2561)new class_2588("gui.buildnotes.main_title"), null);
        this.currentTab = startTab;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int tabWidth = 80;
        int tabHeight = 20;
        this.notesTab = (TabButtonWidget)this.method_37063((class_364)new TabButtonWidget(this.field_22789 / 2 - tabWidth - 2, 15, tabWidth, tabHeight, (class_2561)new class_2588("gui.buildnotes.notes_tab"), b -> this.selectTab(TabType.NOTES)));
        this.buildsTab = (TabButtonWidget)this.method_37063((class_364)new TabButtonWidget(this.field_22789 / 2 + 2, 15, tabWidth, tabHeight, (class_2561)new class_2588("gui.buildnotes.builds_tab"), b -> this.selectTab(TabType.BUILDS)));
        int topMargin = 40;
        int bottomMargin = 85;
        this.noteListWidget = new NoteListWidget(this, this.field_22787, this.field_22789, this.field_22790, topMargin, this.field_22790 - bottomMargin, 38);
        this.buildListWidget = new BuildListWidget(this, this.field_22787, this.field_22789, this.field_22790, topMargin, this.field_22790 - bottomMargin, 38);
        this.method_25429((class_364)this.noteListWidget);
        this.method_25429((class_364)this.buildListWidget);
        int searchFieldWidth = 160;
        int searchBarHeight = 20;
        int searchFieldX = (this.field_22789 - searchFieldWidth) / 2;
        int listBottomY = this.field_22790 - bottomMargin;
        int buttonsTopY = this.field_22790 - 40;
        int searchBarY = listBottomY + (buttonsTopY - listBottomY - searchBarHeight) / 2;
        this.searchField = new MultiLineTextFieldWidget(this.field_22793, searchFieldX, searchBarY, searchFieldWidth, searchBarHeight, "", "Search...", 1, false);
        this.searchField.setChangedListener(this::onSearchTermChanged);
        this.method_25429(this.searchField);
        int buttonsY = this.field_22790 - 20 - 12;
        UIHelper.createBottomButtonRow((class_437)this, buttonsY, 5, x -> {
            int index = (x - UIHelper.getCenteredButtonStartX(this.field_22789, 5)) / 78;
            switch (index) {
                case 0: {
                    this.addButton = (DarkButtonWidget)this.method_37063((class_364)new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)new class_2588("gui.buildnotes.add_button"), b -> this.addEntry()));
                    break;
                }
                case 1: {
                    this.openButton = (DarkButtonWidget)this.method_37063((class_364)new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)new class_2588("gui.buildnotes.open_button"), b -> this.openSelected()));
                    break;
                }
                case 2: {
                    this.editButton = (DarkButtonWidget)this.method_37063((class_364)new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)new class_2588("gui.buildnotes.edit_button"), b -> this.editSelected()));
                    break;
                }
                case 3: {
                    this.deleteButton = (DarkButtonWidget)this.method_37063((class_364)new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)new class_2588("gui.buildnotes.delete_button"), b -> this.confirmDelete()));
                    break;
                }
                case 4: {
                    this.closeButton = (DarkButtonWidget)this.method_37063((class_364)new DarkButtonWidget((int)x, buttonsY, 70, 20, (class_2561)new class_2588("gui.buildnotes.close_button"), b -> this.field_22787.method_1507(null)));
                }
            }
        });
        this.refreshData();
        this.method_20085(this.searchField);
    }

    public void refreshData() {
        this.selectTab(this.currentTab);
    }

    private void onSearchTermChanged(String newTerm) {
        this.searchTerm = newTerm.toLowerCase().trim();
        this.refreshListContents();
    }

    private void refreshListContents() {
        if (this.currentTab == TabType.NOTES) {
            List<Note> allNotes = DataManager.getInstance().getNotes();
            if (!this.searchTerm.isEmpty()) {
                List<Note> filteredNotes = allNotes.stream().filter(note -> note.getTitle().toLowerCase().contains(this.searchTerm)).collect(Collectors.toList());
                this.noteListWidget.setNotes(filteredNotes);
            } else {
                this.noteListWidget.setNotes(allNotes);
            }
        } else {
            List<Build> allBuilds = DataManager.getInstance().getBuilds();
            if (!this.searchTerm.isEmpty()) {
                List<Build> filteredBuilds = allBuilds.stream().filter(build -> build.getName().toLowerCase().contains(this.searchTerm)).collect(Collectors.toList());
                this.buildListWidget.setBuilds(filteredBuilds);
            } else {
                this.buildListWidget.setBuilds(allBuilds);
            }
        }
        this.updateActionButtons();
    }

    private void selectTab(TabType tab) {
        this.currentTab = tab;
        boolean isNotes = tab == TabType.NOTES;
        this.notesTab.setActive(isNotes);
        this.buildsTab.setActive(!isNotes);
        this.noteListWidget.setVisible(isNotes);
        this.buildListWidget.setVisible(!isNotes);
        this.noteListWidget.setSelected(null);
        this.buildListWidget.setSelected(null);
        this.refreshListContents();
        if (isNotes) {
            this.noteListWidget.setNotes(DataManager.getInstance().getNotes());
        } else {
            this.buildListWidget.setBuilds(DataManager.getInstance().getBuilds());
        }
        this.updateActionButtons();
    }

    public void onNoteSelected() {
        this.updateActionButtons();
    }

    public void onBuildSelected() {
        this.updateActionButtons();
    }

    private void updateActionButtons() {
        boolean hasSelection;
        boolean isNotesActive = this.notesTab.isActive();
        this.editButton.field_22763 = hasSelection = isNotesActive ? this.noteListWidget.method_25334() != null : this.buildListWidget.method_25334() != null;
        this.deleteButton.field_22763 = hasSelection;
    }

    public void openSelected() {
        if (this.currentTab == TabType.NOTES) {
            Note sel = this.noteListWidget.getSelectedNote();
            if (sel != null) {
                this.open(new ViewNoteScreen(this, sel));
            }
        } else {
            Build sel = this.buildListWidget.getSelectedBuild();
            if (sel != null) {
                this.open(new ViewBuildScreen(this, sel));
            }
        }
    }

    private void editSelected() {
        if (this.currentTab == TabType.NOTES) {
            Note sel = this.noteListWidget.getSelectedNote();
            if (sel != null) {
                this.open(new EditNoteScreen(this, sel));
            }
        } else {
            Build sel = this.buildListWidget.getSelectedBuild();
            if (sel != null) {
                this.open(new EditBuildScreen(this, sel));
            }
        }
    }

    private void confirmDelete() {
        DataManager dm = DataManager.getInstance();
        if (this.currentTab == TabType.NOTES) {
            Note sel = this.noteListWidget.getSelectedNote();
            if (sel != null) {
                this.showConfirm(class_2561.method_30163((String)("Delete note \"" + sel.getTitle() + "\"?")), () -> {
                    dm.deleteNote(sel);
                    this.open(this);
                });
            }
        } else {
            Build sel = this.buildListWidget.getSelectedBuild();
            if (sel != null) {
                this.showConfirm(class_2561.method_30163((String)("Delete build \"" + sel.getName() + "\"?")), () -> {
                    dm.deleteBuild(sel);
                    this.open(this);
                });
            }
        }
    }

    private void addEntry() {
        if (this.currentTab == TabType.NOTES) {
            Note newNote = new Note("New Note", "");
            this.open(new EditNoteScreen(this, newNote));
        } else {
            Build newBuild = new Build("New Build", "", "", "", "");
            this.open(new EditBuildScreen(this, newBuild));
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        (this.currentTab == TabType.NOTES ? this.noteListWidget : this.buildListWidget).method_25394(matrices, mouseX, mouseY, delta);
        UIHelper.drawPanel(matrices, this.searchField.x - 2, this.searchField.y, this.searchField.width + 4, this.searchField.height);
        this.searchField.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }
}

