/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.atif.buildnotes.Buildnotes;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.Note;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class ServerDataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String NOTES_FILE_NAME = "notes.json";
    private static final String BUILDS_FILE_NAME = "builds.json";
    private static final String MOD_DATA_SUBFOLDER = "buildnotes";
    private final Path storagePath;

    public ServerDataManager(MinecraftServer server) {
        this.storagePath = server.method_27050(class_5218.field_24188).resolve(MOD_DATA_SUBFOLDER);
    }

    private <T> List<T> loadFromFile(String fileName, Type type) {
        List list;
        Path filePath = this.storagePath.resolve(fileName);
        if (Files.notExists(filePath, new LinkOption[0])) {
            return new ArrayList();
        }
        FileReader reader = new FileReader(filePath.toFile());
        try {
            List data = (List)GSON.fromJson((Reader)reader, type);
            list = data != null ? data : new ArrayList();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Buildnotes.LOGGER.error("Failed to load server data from " + fileName, (Throwable)e);
                return new ArrayList();
            }
        }
        reader.close();
        return list;
    }

    private <T> void writeToFile(String fileName, List<T> data) {
        try {
            Files.createDirectories(this.storagePath, new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(this.storagePath.resolve(fileName).toFile());){
                GSON.toJson(data, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Buildnotes.LOGGER.error("Failed to save server data to " + fileName, (Throwable)e);
        }
    }

    public List<Note> getNotes() {
        return this.loadFromFile(NOTES_FILE_NAME, new TypeToken<ArrayList<Note>>(){}.getType());
    }

    public void saveNote(Note note) {
        List<Note> notes = this.getNotes();
        notes.removeIf(n -> n.getId().equals(note.getId()));
        notes.add(note);
        this.writeToFile(NOTES_FILE_NAME, notes);
    }

    public void deleteNote(UUID noteId) {
        List<Note> notes = this.getNotes();
        if (notes.removeIf(n -> n.getId().equals(noteId))) {
            this.writeToFile(NOTES_FILE_NAME, notes);
        }
    }

    public List<Build> getBuilds() {
        return this.loadFromFile(BUILDS_FILE_NAME, new TypeToken<ArrayList<Build>>(){}.getType());
    }

    public void saveBuild(Build build) {
        List<Build> builds = this.getBuilds();
        builds.removeIf(b -> b.getId().equals(build.getId()));
        builds.add(build);
        this.writeToFile(BUILDS_FILE_NAME, builds);
    }

    public void deleteBuild(UUID buildId) {
        List<Build> builds = this.getBuilds();
        if (builds.removeIf(b -> b.getId().equals(buildId))) {
            this.writeToFile(BUILDS_FILE_NAME, builds);
        }
    }
}

