package net.atif.buildnotes.gui.widget.list;

import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import java.util.List;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class BuildListWidget extends AbstractListWidget<BuildListWidget.BuildEntry> {

    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");

    public BuildListWidget(MainScreen parent, class_310 client, int top, int bottom, int itemHeight) {
        super(parent, client, top, bottom, itemHeight);
    }

    public void setBuilds(List<Build> builds) {
        this.method_25339();
        builds.forEach(build -> this.method_25321(new BuildEntry(build)));
    }

    public Build getSelectedBuild() {
        BuildEntry entry = method_25334();
        return entry != null ? entry.getBuild() : null;
    }

    @Override
    public void setSelected(BuildEntry entry) {
        super.method_25313(entry);
        parentScreen.onBuildSelected(); // Notify the parent screen
    }

    public class BuildEntry extends AbstractListWidget.Entry<BuildEntry> {
        private final Build build;
        private final String formattedDateTime;

        public BuildEntry(Build build) {
            this.build = build;

            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(build.getLastModified()), ZoneId.systemDefault());
            this.formattedDateTime = dateTime.format(DATE_TIME_FORMATTER);
        }

        public Build getBuild() {
            return this.build;
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            // Prepare Scope indicator to calculate its width
            class_2561 scopeText = null;
            int scopeWidth = 0;
            if (build.getScope() != null) {
                switch (build.getScope()) {
                    case GLOBAL -> scopeText = class_2561.method_43470("Global").method_27692(class_124.field_1075);
                    case SERVER -> scopeText = class_2561.method_43470("Server").method_27692(class_124.field_1060);
                    // We don't draw an indicator for WORLD scope
                }
            }

            if (scopeText != null) {
                scopeWidth = field_22740.field_1772.method_27525(scopeText);
            }

            // Truncate and draw the Build Name
            // Calculate available width for the name by subtracting space for the scope indicator and padding
            int availableNameWidth = entryWidth - 6; // Base padding
            if (scopeText != null) {
                availableNameWidth -= (scopeWidth + 7); // Account for the scope text and its padding
            }

            String truncatedName = field_22740.field_1772.method_27523(build.getName(), availableNameWidth);
            context.method_51433(field_22740.field_1772, truncatedName, x + 2, y + 2, Colors.TEXT_PRIMARY, false);

            // Draw the Scope indicator
            if (scopeText != null) {
                context.method_51439(field_22740.field_1772, scopeText, x + entryWidth - scopeWidth - 6, y + 2, Colors.TEXT_PRIMARY, false);
            }

            // Truncate and draw the Coordinates
            String fullCoordsText = "Coords: " + build.getCoordinates();
            String truncatedCoords = field_22740.field_1772.method_27523(fullCoordsText, entryWidth - 6);
            context.method_51439(field_22740.field_1772, class_2561.method_43470(truncatedCoords).method_27692(class_124.field_1080), x + 2, y + 12, Colors.TEXT_MUTED, false);

            // Truncate and draw the Date/Time
            String fullDateText = "Last Modified: " + this.formattedDateTime;
            String truncatedDate = field_22740.field_1772.method_27523(fullDateText, entryWidth - 6);
            context.method_51433(field_22740.field_1772, truncatedDate, x + 2, y + 22, Colors.TEXT_MUTED, false);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                BuildListWidget.this.setSelected(this);

                BuildListWidget.this.handleEntryClick(this);
                return true;
            }
            return false;
        }
    }
}