/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.client;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.Note;

public class ClientCache {
    private static final List<Note> serverNotes = new CopyOnWriteArrayList<Note>();
    private static final List<Build> serverBuilds = new CopyOnWriteArrayList<Build>();

    public static List<Note> getNotes() {
        return serverNotes;
    }

    public static List<Build> getBuilds() {
        return serverBuilds;
    }

    public static void setNotes(List<Note> notes) {
        serverNotes.clear();
        serverNotes.addAll(notes);
    }

    public static void setBuilds(List<Build> builds) {
        serverBuilds.clear();
        serverBuilds.addAll(builds);
    }

    public static void addOrUpdateNote(Note note) {
        serverNotes.removeIf(n -> n.getId().equals(note.getId()));
        serverNotes.add(note);
    }

    public static void addOrUpdateBuild(Build build) {
        serverBuilds.removeIf(b -> b.getId().equals(build.getId()));
        serverBuilds.add(build);
    }

    public static void removeNoteById(UUID id) {
        serverNotes.removeIf(n -> n.getId().equals(id));
    }

    public static void removeBuildById(UUID id) {
        serverBuilds.removeIf(b -> b.getId().equals(id));
    }

    public static void clear() {
        serverNotes.clear();
        serverBuilds.clear();
    }
}

