/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes;

import net.atif.buildnotes.data.PermissionLevel;
import net.atif.buildnotes.network.ModPackets;
import net.atif.buildnotes.network.ServerPacketHandler;
import net.atif.buildnotes.network.packet.c2s.DeleteBuildC2SPacket;
import net.atif.buildnotes.network.packet.c2s.DeleteNoteC2SPacket;
import net.atif.buildnotes.network.packet.c2s.RequestDataC2SPacket;
import net.atif.buildnotes.network.packet.c2s.RequestImageC2SPacket;
import net.atif.buildnotes.network.packet.c2s.SaveBuildC2SPacket;
import net.atif.buildnotes.network.packet.c2s.SaveNoteC2SPacket;
import net.atif.buildnotes.network.packet.c2s.UploadImageChunkC2SPacket;
import net.atif.buildnotes.network.packet.s2c.HandshakeS2CPacket;
import net.atif.buildnotes.server.PermissionManager;
import net.atif.buildnotes.server.ServerDataManager;
import net.atif.buildnotes.server.ServerImageTransferManager;
import net.atif.buildnotes.server.command.BuildNotesCommands;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Buildnotes
implements ModInitializer {
    public static final String MOD_ID = "buildnotes";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"buildnotes");
    public static ServerDataManager SERVER_DATA_MANAGER;
    public static PermissionManager PERMISSION_MANAGER;

    public void onInitialize() {
        LOGGER.info("BuildNotes Initialized!");
        ModPackets.registerC2SPackets();
        ModPackets.registerS2CPackets();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            SERVER_DATA_MANAGER = new ServerDataManager(server);
            PERMISSION_MANAGER = new PermissionManager(server);
        });
        BuildNotesCommands.register();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            if (!server.method_3816()) {
                return;
            }
            PermissionLevel permission = PERMISSION_MANAGER.isAllowedToEdit(player) ? PermissionLevel.CAN_EDIT : PermissionLevel.VIEW_ONLY;
            ServerPlayNetworking.send((class_3222)player, (class_8710)new HandshakeS2CPacket(permission));
            LOGGER.info("Sent handshake packet to {}", (Object)player.method_5477().getString());
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ServerImageTransferManager.onPlayerDisconnect(handler.field_14140.method_5667()));
        ServerPlayNetworking.registerGlobalReceiver(DeleteNoteC2SPacket.ID, (packet, context) -> {
            MinecraftServer server = context.server();
            server.execute(() -> ServerPacketHandler.handleDeleteNote(server, context.player(), packet));
        });
        ServerPlayNetworking.registerGlobalReceiver(RequestDataC2SPacket.ID, (packet, context) -> {
            MinecraftServer server = context.server();
            server.execute(() -> ServerPacketHandler.handleRequestInitialData(server, context.player(), packet));
        });
        ServerPlayNetworking.registerGlobalReceiver(SaveNoteC2SPacket.ID, (packet, context) -> {
            MinecraftServer server = context.server();
            server.execute(() -> ServerPacketHandler.handleSaveNote(server, context.player(), packet));
        });
        ServerPlayNetworking.registerGlobalReceiver(SaveBuildC2SPacket.ID, (packet, context) -> {
            MinecraftServer server = context.server();
            server.execute(() -> ServerPacketHandler.handleSaveBuild(server, context.player(), packet));
        });
        ServerPlayNetworking.registerGlobalReceiver(DeleteBuildC2SPacket.ID, (packet, context) -> {
            MinecraftServer server = context.server();
            server.execute(() -> ServerPacketHandler.handleDeleteBuild(server, context.player(), packet));
        });
        ServerPlayNetworking.registerGlobalReceiver(UploadImageChunkC2SPacket.ID, (packet, context) -> {
            MinecraftServer server = context.server();
            server.execute(() -> ServerPacketHandler.handleImageChunkUpload(server, context.player(), packet));
        });
        ServerPlayNetworking.registerGlobalReceiver(RequestImageC2SPacket.ID, (packet, context) -> {
            MinecraftServer server = context.server();
            server.execute(() -> ServerPacketHandler.handleImageRequest(server, context.player(), packet));
        });
    }
}

