package net.atif.buildnotes.gui.helper;

import net.atif.buildnotes.gui.screen.ConfirmScreen;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import java.util.function.Consumer;

import static net.minecraft.class_332.method_25294;

public class UIHelper {

    public static final int BUTTON_WIDTH = 80;
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTON_SPACING = 8;
    public static final int BOTTOM_PADDING = 12;

    /**
     * Draws the standard dark, semi-transparent panel background.
     */
    public static void drawPanel(class_4587 matrices, int x, int y, int width, int height) {
        method_25294(matrices, x, y, x + width, y + height, 0x77000000);
    }

    /**
     * Calculates the starting X position for a row of centered buttons.
     */
    public static int getCenteredButtonStartX(int screenWidth, int buttonCount) {
        int totalWidth = (buttonCount * BUTTON_WIDTH) + ((buttonCount - 1) * BUTTON_SPACING);
        return (screenWidth - totalWidth) / 2;
    }

    /**
     * A helper for creating and adding a row of action buttons at the given Y.
     * The consumer receives the computed X coordinate for each button and should
     * create/add the button there (like screen.addDrawableChild(new DarkButtonWidget(...))).
     *
     * Returns the Y passed in (convenience).
     */
    public static int createBottomButtonRow(class_437 screen, int y, int buttonCount, Consumer<Integer> buttonCreator) {
        int startX = getCenteredButtonStartX(screen.field_22789, buttonCount);
        for (int i = 0; i < buttonCount; i++) {
            int buttonX = startX + i * (BUTTON_WIDTH + BUTTON_SPACING);
            buttonCreator.accept(buttonX);
        }
        return y;
    }

    /**
     * Shortcut to open a standard confirm dialog that returns to the given parent on cancel.
     */
    public static void showConfirmDialog(class_437 parent, class_2561 message, Runnable onConfirm) {
        class_310.method_1551().method_1507(new ConfirmScreen(parent, message, onConfirm, () -> class_310.method_1551().method_1507(parent)));
    }

    /**
     * Computes a centered panel rectangle. Returns int[] { x, y, width, height }.
     * maxWidth is the maximum allowed panel width (we clamp to screenWidth - 80 like other screens).
     */
    public static int[] getCenteredPanel(int screenWidth, int screenHeight, int maxWidth, int panelHeight) {
        int panelW = Math.min(screenWidth - 80, maxWidth);
        int x = (screenWidth - panelW) / 2;
        int y = (screenHeight - panelHeight) / 2;
        return new int[] { x, y, panelW, panelHeight };
    }
}
