package net.atif.buildnotes.gui.screen;

import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.MultiLineTextFieldWidget;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class EditNoteScreen extends BaseScreen {

    private final Note note;

    private MultiLineTextFieldWidget titleField;
    private MultiLineTextFieldWidget contentField;

    private DarkButtonWidget globalToggleButton;

    public EditNoteScreen(class_437 parent, Note note) {
        super(new class_2588("gui.buildnotes.edit_note_title"), parent); // A new translation key could be "Editing Note"
        this.note = note;
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        int contentWidth = (int) (this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int topMargin = 20;
        int titlePanelHeight = 25;
        int panelSpacing = 5;
        int bottomMargin = 70;

        // --- Title Text Field ---
        this.titleField = new MultiLineTextFieldWidget(
                this.field_22793,
                contentX,
                topMargin + 5,
                contentWidth,
                titlePanelHeight,
                note.getTitle(),
                "Enter Title Here",
                1, false
        );
        this.method_25429(this.titleField);

        // --- Content Text Field ---
        int contentPanelY = topMargin + titlePanelHeight + panelSpacing;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        this.contentField = new MultiLineTextFieldWidget(
                this.field_22793, contentX, contentPanelY, contentWidth,
                contentPanelBottom - contentPanelY, note.getContent(),
                "Enter Text Here ", Integer.MAX_VALUE, true
        );
        this.method_25429(this.contentField);

        // --- TOP BUTTON ROW (3) ---
        int topRowY = this.field_22790 - (UIHelper.BUTTON_HEIGHT + UIHelper.BOTTOM_PADDING) - UIHelper.BUTTON_HEIGHT - 5;
        UIHelper.createBottomButtonRow(this, topRowY, 3, x -> {
            int idx = (x - UIHelper.getCenteredButtonStartX(this.field_22789, 3)) / (UIHelper.BUTTON_WIDTH + UIHelper.BUTTON_SPACING);
            switch (idx) {
                case 0 -> this.method_37063(new DarkButtonWidget(x, topRowY, UIHelper.BUTTON_WIDTH, UIHelper.BUTTON_HEIGHT,
                        new class_2585("Coords"), b -> insertCoords()));
                case 1 -> this.method_37063(new DarkButtonWidget(x, topRowY, UIHelper.BUTTON_WIDTH, UIHelper.BUTTON_HEIGHT,
                        new class_2585("Biome"), b -> insertBiome()));
                case 2 -> {
                    this.globalToggleButton = this.method_37063(new DarkButtonWidget(x, topRowY, UIHelper.BUTTON_WIDTH, UIHelper.BUTTON_HEIGHT,
                            getGlobalButtonText(), b -> {
                        note.setGlobal(!note.isGlobal());
                        this.globalToggleButton.method_25355(getGlobalButtonText());
                    }));
                }
            }
        });

        // --- BOTTOM BUTTON ROW (2) ---
        int bottomRowY = this.field_22790 - UIHelper.BUTTON_HEIGHT - UIHelper.BOTTOM_PADDING;
        UIHelper.createBottomButtonRow(this, bottomRowY, 2, x -> {
            int idx = (x - UIHelper.getCenteredButtonStartX(this.field_22789, 2)) / (UIHelper.BUTTON_WIDTH + UIHelper.BUTTON_SPACING);
            if (idx == 0) {
                this.method_37063(new DarkButtonWidget(x, bottomRowY, UIHelper.BUTTON_WIDTH, UIHelper.BUTTON_HEIGHT,
                        new class_2585("Save"), button -> saveNote()));
            } else {
                this.method_37063(new DarkButtonWidget(x, bottomRowY, UIHelper.BUTTON_WIDTH, UIHelper.BUTTON_HEIGHT,
                        new class_2588("gui.buildnotes.close_button"), button -> saveAndClose()));
            }
        });

        this.method_20085(this.titleField);
    }

    private class_2585 getGlobalButtonText() {
        return new class_2585("Scope: " + (note.isGlobal() ? "Global" : "World"));
    }

    private void saveNote() {
        note.setTitle(this.titleField.getText());
        note.setContent(this.contentField.getText());
        note.updateTimestamp();
        DataManager.getInstance().saveNote(this.note);
    }

    private void saveAndClose() {
        saveNote();
        this.method_25419();
    }

    private void insertCoords() {
        if (this.field_22787.field_1724 == null) return;
        String coords = String.format("X: %.0f, Y: %.0f, Z: %.0f", this.field_22787.field_1724.method_23317(), this.field_22787.field_1724.method_23318(), this.field_22787.field_1724.method_23321());
        this.contentField.insertText(coords);
    }

    private void insertBiome() {
        if (this.field_22787.field_1724 == null || this.field_22787.field_1687 == null) return;
        class_2338 playerPos = this.field_22787.field_1724.method_24515();
        String biomeId = this.field_22787.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221(this.field_22787.field_1687.method_23753(playerPos).comp_349()).toString();
        this.contentField.insertText(biomeId);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);

        int contentWidth = (int) (this.field_22789 * 0.6);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int topMargin = 20;
        int titlePanelHeight = 25;
        int panelSpacing = 5;
        int bottomMargin = 70;

        // --- Title Panel ---
        UIHelper.drawPanel(matrices, contentX, topMargin, contentWidth, titlePanelHeight);;
        this.titleField.method_25394(matrices, mouseX, mouseY, delta);

        // --- Content Panel ---
        int contentPanelY = topMargin + titlePanelHeight + panelSpacing;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        UIHelper.drawPanel(matrices, contentX, contentPanelY, contentWidth, contentPanelBottom - contentPanelY);
        this.contentField.method_25394(matrices, mouseX, mouseY, delta);

        // Draw screen title
        method_27534(matrices, this.field_22793, new class_2585("Editing Note"), this.field_22789 / 2, 8, 0xFFFFFF);

        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    // We need to override mouseScrolled to pass the event to our custom widget
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return this.contentField.method_25401(mouseX, mouseY, amount) || super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    public void method_25419() {
        saveNote();
        super.method_25419();
    }
}