/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.data;

import java.time.Instant;
import java.util.UUID;

public abstract class BaseEntry {
    private final UUID id = UUID.randomUUID();
    private long lastModified;
    private boolean isGlobal = false;

    protected BaseEntry() {
        this.updateTimestamp();
    }

    public void updateTimestamp() {
        this.lastModified = Instant.now().getEpochSecond();
    }

    public UUID getId() {
        return this.id;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean global) {
        this.isGlobal = global;
    }
}

