/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.atif.buildnotes.data.BaseEntry;
import net.atif.buildnotes.data.CustomField;

public class Build
extends BaseEntry {
    private String name;
    private String coordinates;
    private String dimension;
    private String description;
    private String credits;
    private final List<CustomField> customFields;
    private List<String> imageFileNames;

    public Build(String name, String coordinates, String dimension, String description, String credits) {
        this.name = name;
        this.coordinates = coordinates;
        this.dimension = dimension;
        this.description = description;
        this.credits = credits;
        this.customFields = new ArrayList<CustomField>();
        this.imageFileNames = new ArrayList<String>();
    }

    protected Build() {
        this.customFields = new ArrayList<CustomField>();
        this.imageFileNames = new ArrayList<String>();
    }

    @Override
    public UUID getId() {
        return super.getId();
    }

    public String getName() {
        return this.name;
    }

    public String getCoordinates() {
        return this.coordinates;
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCredits() {
        return this.credits;
    }

    public List<CustomField> getCustomFields() {
        return this.customFields;
    }

    public List<String> getImageFileNames() {
        if (this.imageFileNames == null) {
            this.imageFileNames = new ArrayList<String>();
        }
        return this.imageFileNames;
    }

    @Override
    public long getLastModified() {
        return super.getLastModified();
    }

    @Override
    public boolean isGlobal() {
        return super.isGlobal();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCredits(String credits) {
        this.credits = credits;
    }

    @Override
    public void setGlobal(boolean global) {
        super.setGlobal(global);
    }
}

