/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.atif.buildnotes.Buildnotes;
import net.atif.buildnotes.data.BaseEntry;
import net.atif.buildnotes.data.Build;
import net.atif.buildnotes.data.Note;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_5218;

public class DataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path GLOBAL_PATH = FabricLoader.getInstance().getConfigDir();
    private static final String NOTES_FILE_NAME = "notes.json";
    private static final String BUILDS_FILE_NAME = "builds.json";
    private static final String MOD_DATA_SUBFOLDER = "buildnotes";
    private static DataManager instance;

    private DataManager() {
    }

    public static DataManager getInstance() {
        if (instance == null) {
            instance = new DataManager();
        }
        return instance;
    }

    private Path getWorldSpecificPath() {
        class_310 client = class_310.method_1551();
        if (client.method_1496() && client.method_1576() != null) {
            return client.method_1576().method_27050(class_5218.field_24188).resolve(MOD_DATA_SUBFOLDER);
        }
        return null;
    }

    public List<Note> getNotes() {
        List<Note> globalNotes = this.loadNotes(GLOBAL_PATH.resolve(MOD_DATA_SUBFOLDER));
        Path worldPath = this.getWorldSpecificPath();
        List<Object> worldNotes = new ArrayList();
        if (worldPath != null) {
            worldNotes = this.loadNotes(worldPath);
        }
        return Stream.concat(worldNotes.stream(), globalNotes.stream()).sorted(Comparator.comparingLong(BaseEntry::getLastModified).reversed()).collect(Collectors.toList());
    }

    public void saveNote(Note noteToSave) {
        List<Note> allNotes = this.getNotes();
        allNotes.removeIf(n -> n.getId().equals(noteToSave.getId()));
        allNotes.add(noteToSave);
        List<Note> globalNotes = allNotes.stream().filter(BaseEntry::isGlobal).collect(Collectors.toList());
        List<Note> worldNotes = allNotes.stream().filter(n -> !n.isGlobal()).collect(Collectors.toList());
        this.writeNotesToFile(globalNotes, GLOBAL_PATH.resolve(MOD_DATA_SUBFOLDER));
        Path worldPath = this.getWorldSpecificPath();
        if (worldPath != null) {
            this.writeNotesToFile(worldNotes, worldPath);
        }
    }

    public void deleteNote(Note noteToDelete) {
        List<Note> allNotes = this.getNotes();
        allNotes.removeIf(n -> n.getId().equals(noteToDelete.getId()));
        List<Note> globalNotes = allNotes.stream().filter(BaseEntry::isGlobal).collect(Collectors.toList());
        List<Note> worldNotes = allNotes.stream().filter(n -> !n.isGlobal()).collect(Collectors.toList());
        this.writeNotesToFile(globalNotes, GLOBAL_PATH.resolve(MOD_DATA_SUBFOLDER));
        Path worldPath = this.getWorldSpecificPath();
        if (worldPath != null) {
            this.writeNotesToFile(worldNotes, worldPath);
        }
    }

    private void writeNotesToFile(List<Note> notes, Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(path.resolve(NOTES_FILE_NAME).toFile());){
                GSON.toJson(notes, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Buildnotes.LOGGER.error("Could not save notes to " + path.toString(), (Throwable)e);
        }
    }

    private List<Note> loadNotes(Path path) {
        List list;
        File notesFile = path.resolve(NOTES_FILE_NAME).toFile();
        if (!notesFile.exists()) {
            return new ArrayList<Note>();
        }
        FileReader reader = new FileReader(notesFile);
        try {
            Type type = new TypeToken<ArrayList<Note>>(){}.getType();
            List loadedNotes = (List)GSON.fromJson((Reader)reader, type);
            list = loadedNotes != null ? loadedNotes : new ArrayList();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Buildnotes.LOGGER.warn("Could not load notes from " + String.valueOf(path) + ", creating new list...");
                return new ArrayList<Note>();
            }
        }
        reader.close();
        return list;
    }

    public List<Build> getBuilds() {
        List<Build> globalBuilds = this.loadBuilds(GLOBAL_PATH.resolve(MOD_DATA_SUBFOLDER));
        Path worldPath = this.getWorldSpecificPath();
        List<Object> worldBuilds = new ArrayList();
        if (worldPath != null) {
            worldBuilds = this.loadBuilds(worldPath);
        }
        return Stream.concat(worldBuilds.stream(), globalBuilds.stream()).sorted(Comparator.comparingLong(Build::getLastModified).reversed()).collect(Collectors.toList());
    }

    public void saveBuild(Build buildToSave) {
        List<Build> allBuilds = this.getBuilds();
        allBuilds.removeIf(b -> b.getId().equals(buildToSave.getId()));
        allBuilds.add(buildToSave);
        List<Build> globalBuilds = allBuilds.stream().filter(Build::isGlobal).collect(Collectors.toList());
        List<Build> worldBuilds = allBuilds.stream().filter(b -> !b.isGlobal()).collect(Collectors.toList());
        this.writeBuildsToFile(globalBuilds, GLOBAL_PATH.resolve(MOD_DATA_SUBFOLDER));
        Path worldPath = this.getWorldSpecificPath();
        if (worldPath != null) {
            this.writeBuildsToFile(worldBuilds, worldPath);
        }
    }

    public void deleteBuild(Build buildToDelete) {
        block9: {
            List<Build> allBuilds = this.getBuilds();
            allBuilds.removeIf(b -> b.getId().equals(buildToDelete.getId()));
            List<Build> globalBuilds = allBuilds.stream().filter(Build::isGlobal).collect(Collectors.toList());
            List<Build> worldBuilds = allBuilds.stream().filter(b -> !b.isGlobal()).collect(Collectors.toList());
            this.writeBuildsToFile(globalBuilds, GLOBAL_PATH.resolve(MOD_DATA_SUBFOLDER));
            Path worldPath = this.getWorldSpecificPath();
            if (worldPath != null) {
                this.writeBuildsToFile(worldBuilds, worldPath);
            }
            try {
                Path imageDir = FabricLoader.getInstance().getConfigDir().resolve(MOD_DATA_SUBFOLDER).resolve("images").resolve(buildToDelete.getId().toString());
                if (!Files.exists(imageDir, new LinkOption[0])) break block9;
                try (Stream<Path> walk = Files.walk(imageDir, new FileVisitOption[0]);){
                    walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
            }
            catch (IOException e) {
                Buildnotes.LOGGER.error("Failed to delete image directory for build: {}", (Object)buildToDelete.getId(), (Object)e);
            }
        }
    }

    private void writeBuildsToFile(List<Build> builds, Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(path.resolve(BUILDS_FILE_NAME).toFile());){
                GSON.toJson(builds, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Buildnotes.LOGGER.error("Could not save builds to " + path.toString(), (Throwable)e);
        }
    }

    private List<Build> loadBuilds(Path path) {
        List list;
        File buildsFile = path.resolve(BUILDS_FILE_NAME).toFile();
        if (!buildsFile.exists()) {
            return new ArrayList<Build>();
        }
        FileReader reader = new FileReader(buildsFile);
        try {
            Type type = new TypeToken<ArrayList<Build>>(){}.getType();
            List loadedBuilds = (List)GSON.fromJson((Reader)reader, type);
            list = loadedBuilds != null ? loadedBuilds : new ArrayList();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Buildnotes.LOGGER.warn("Could not load builds from " + path.toString() + ", creating new list...");
                return new ArrayList<Build>();
            }
        }
        reader.close();
        return list;
    }
}

